/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import groovy.lang.Range;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class RangeConstraint
extends AbstractConstraint {
    private final Range range;

    public RangeConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.range = (Range)constraintParameter;
    }

    public Range getRange() {
        return this.range;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (Comparable.class.isAssignableFrom(type) || ClassUtils.isAssignableOrConvertibleFrom(Number.class, (Class)type));
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Range)) {
            throw new IllegalArgumentException("Parameter for constraint [range] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [groovy.lang.Range]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "range";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.range.contains(propertyValue)) {
            return;
        }
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.range.getFrom(), this.range.getTo()};
        Comparable from = this.range.getFrom();
        Comparable to = this.range.getTo();
        if (from instanceof Number && propertyValue instanceof Number) {
            from = Long.valueOf(((Number)((Object)from)).longValue());
            to = Long.valueOf(((Number)((Object)to)).longValue());
            propertyValue = ((Number)propertyValue).longValue();
        }
        if (from.compareTo(propertyValue) > 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toosmall", args);
        } else if (to.compareTo(propertyValue) < 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toobig", args);
        }
    }
}

