/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.grails.maven.plugin.tools.ForkedGrailsRuntime;
import org.grails.maven.plugin.tools.GrailsServices;

public abstract class AbstractGrailsMojo
extends AbstractMojo {
    public static final String DEPENDENCY_FILE_LOC = "org.grails.ide.eclipse.dependencies.filename";
    public static final String GRAILS_BUILD_LISTENERS = "grails.build.listeners";
    public static final String PLUGIN_PREFIX = "grails-";
    public static final String APP_GRAILS_VERSION = "app.grails.version";
    public static final String APP_VERSION = "app.version";
    public static final String SPRING_LOADED_VERSION = "1.2.0.RELEASE";
    public static final List<String> COMPILE_PLUS_RUNTIME_SCOPE = Arrays.asList("compile", "runtime");
    protected boolean activateAgent;
    protected File basedir;
    protected String env;
    protected String grailsEnv;
    protected String grailsVersion;
    private String groovyVersion;
    protected String grailsWorkDir;
    protected boolean nonInteractive = true;
    protected boolean showStacktrace;
    protected boolean fork = false;
    protected List forkedVmArgs;
    protected boolean forkDebug = false;
    protected int forkPermGen = 256;
    protected int forkMaxMemory = 1024;
    protected int forkMinMemory = 512;
    protected File pluginsDir;
    protected Settings settings;
    protected MavenProject project;
    private ArtifactRepository localRepository;
    private String extraClasspathEntries;
    private String grailsBuildListener;
    private String dependencyFileLocation;
    private GrailsServices grailsServices;
    private ProjectDependenciesResolver projectDependenciesResolver;
    private RepositorySystem repoSystem;
    private ProjectBuilder projectBuilder;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;

    protected AbstractGrailsMojo() {
    }

    protected File getBasedir() {
        if (this.basedir == null) {
            throw new RuntimeException("Your subclass have a field called 'basedir'. Remove it and use getBasedir() instead.");
        }
        return this.basedir;
    }

    protected String getEnvironment() {
        if (this.env == null) {
            return this.grailsEnv;
        }
        return this.env;
    }

    protected GrailsServices getGrailsServices() {
        this.grailsServices.setBasedir(this.basedir);
        return this.grailsServices;
    }

    protected void runGrails(String targetName) throws MojoExecutionException {
        this.runGrails(targetName, System.getProperty("grails.cli.args"));
    }

    protected void runGrails(String targetName, String args) throws MojoExecutionException {
        this.configureMavenProxy();
        String targetDir = this.project.getBuild().getDirectory();
        ForkedGrailsRuntime.ExecutionContext ec = new ForkedGrailsRuntime.ExecutionContext();
        ec.setBuildDependencies(this.resolveBuildDependencies());
        List<File> providedDependencies = this.resolveArtifacts("provided");
        List<File> compileDependencies = this.resolveArtifacts("compile");
        List<File> runtimeDependencies = this.resolveArtifacts(COMPILE_PLUS_RUNTIME_SCOPE);
        HashSet<File> testDependencies = new HashSet<File>(this.resolveArtifacts("test"));
        testDependencies.addAll(providedDependencies);
        testDependencies.addAll(compileDependencies);
        testDependencies.addAll(runtimeDependencies);
        ec.setProvidedDependencies(providedDependencies);
        ec.setRuntimeDependencies(new ArrayList<File>(runtimeDependencies));
        ec.setCompileDependencies(compileDependencies);
        ec.setTestDependencies(new ArrayList<File>(testDependencies));
        ec.setGrailsWorkDir(new File(this.grailsWorkDir));
        ec.setProjectWorkDir(new File(targetDir));
        ec.setClassesDir(new File(targetDir, "classes"));
        ec.setTestClassesDir(new File(targetDir, "test-classes"));
        ec.setResourcesDir(new File(targetDir, "resources"));
        ec.setProjectPluginsDir(this.pluginsDir);
        ec.setForkedVmArgs(this.forkedVmArgs);
        if (this.nonInteractive) {
            String string = args = args != null ? "--non-interactive " + args : "--non-interactive ";
        }
        if (this.showStacktrace) {
            String string = args = args != null ? "--stacktrace " + args : "--stacktrace ";
        }
        if (this.grailsBuildListener != null) {
            ec.setGrailsBuildListener(this.grailsBuildListener);
        }
        if (this.dependencyFileLocation != null) {
            ec.setDependencyFileLocation(new File(this.dependencyFileLocation));
        }
        args = args != null ? "--plain-output " + args : "--plain-output";
        ec.setArgs(args);
        ec.setScriptName(targetName);
        ec.setBaseDir(this.project.getBasedir());
        ec.setEnv(this.getEnvironment());
        ForkedGrailsRuntime fgr = new ForkedGrailsRuntime(ec);
        if (this.activateAgent) {
            File springLoadedJar = this.resolveArtifact("org.springframework:springloaded:1.2.0.RELEASE");
            if (springLoadedJar != null) {
                fgr.setReloadingAgent(springLoadedJar);
            } else {
                this.getLog().warn((CharSequence)"Grails Reloading: org.springframework:springloaded:1.2.0.RELEASE not found");
                this.getLog().error((CharSequence)"Grails Reloading: not enabled");
            }
        }
        fgr.setDebug(this.forkDebug);
        fgr.setMaxMemory(this.forkMaxMemory);
        fgr.setMaxPerm(this.forkPermGen);
        fgr.setMinMemory(this.forkMinMemory);
        try {
            this.handleVersionSync();
            fgr.fork();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected Collection<File> resolveArtifactIds(Collection<String> artifactIds) throws MojoExecutionException {
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        for (String artifactId : artifactIds) {
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(artifactId));
            request.setRepositories(this.remoteRepos);
            this.getLog().debug((CharSequence)("Resolving artifact " + artifactId + " from " + this.remoteRepos));
            requests.add(request);
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            List result = this.repoSystem.resolveArtifacts(this.repoSession, requests);
            for (ArtifactResult artifactResult : result) {
                File file = artifactResult.getArtifact().getFile();
                files.add(file);
                this.getLog().debug((CharSequence)("Resolved artifact " + artifactResult.getArtifact().getArtifactId() + " to " + file + " from " + artifactResult.getRepository()));
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return files;
    }

    protected File resolveArtifact(String artifactId) throws MojoExecutionException {
        File file;
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(artifactId));
        request.setRepositories(this.remoteRepos);
        this.getLog().debug((CharSequence)("Resolving artifact " + artifactId + " from " + this.remoteRepos));
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
            file = result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("Resolved artifact " + artifactId + " to " + file + " from " + result.getRepository()));
        return file;
    }

    protected List<File> resolveArtifacts() throws MojoExecutionException {
        return this.resolveArtifacts("compile");
    }

    protected List<File> resolveArtifacts(Collection<String> scopes) throws MojoExecutionException {
        MavenProject mavenProject = this.project;
        return this.resolveArtifacts(mavenProject, scopes);
    }

    protected List<File> resolveArtifacts(String scope) throws MojoExecutionException {
        MavenProject mavenProject = this.project;
        return this.resolveArtifacts(mavenProject, Arrays.asList(scope));
    }

    protected List<File> resolveArtifacts(MavenProject mavenProject, Collection<String> scopes) throws MojoExecutionException {
        return this.resolveArtifacts(mavenProject, scopes, null);
    }

    protected List<File> resolveArtifacts(MavenProject mavenProject, Collection<String> scopes, DependencyFilter filter) throws MojoExecutionException {
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(mavenProject, this.repoSession);
            if (filter != null) {
                request.setResolutionFilter((DependencyFilter)new AndDependencyFilter(new DependencyFilter[]{new ScopeDependencyFilter(scopes, Collections.emptyList()), filter}));
            } else {
                request.setResolutionFilter((DependencyFilter)new ScopeDependencyFilter(scopes, Collections.emptyList()));
            }
            DependencyResolutionResult result = this.projectDependenciesResolver.resolve((DependencyResolutionRequest)request);
            List dependencies = result.getDependencies();
            ArrayList<File> files = new ArrayList<File>();
            for (Dependency d : dependencies) {
                String name;
                org.eclipse.aether.artifact.Artifact artifact = d.getArtifact();
                File file = artifact.getFile();
                if (file == null || (name = file.getName()).contains("xml-apis") || name.contains("commons-logging")) continue;
                files.add(file);
            }
            return files;
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Dependency resolution failure: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected List<File> resolveBuildDependencies() throws MojoExecutionException {
        try {
            MavenProject pluginProject = this.getPluginProject();
            HashSet<File> jars = new HashSet<File>();
            String grailsVersion = this.establishGrailsVersion();
            String groovyVersion = this.establishGroovyVersion();
            if (grailsVersion != null) {
                String scriptsId = "org.grails:grails-scripts:" + grailsVersion;
                String bootstrapId = "org.grails:grails-bootstrap:" + grailsVersion;
                String groovyId = "org.codehaus.groovy:groovy-all:" + groovyVersion;
                jars.addAll(this.resolveArtifactIds(Arrays.asList(scriptsId, bootstrapId, groovyId)));
            }
            jars.addAll(this.resolveArtifacts(pluginProject, COMPILE_PLUS_RUNTIME_SCOPE, (DependencyFilter)new ExclusionsDependencyFilter(Arrays.asList("org.grails:grails-bootstrap", "org.codehaus.groovy:groovy-all", "org.codehaus.groovy:groovy"))));
            this.findAndAddToolsJar(jars);
            this.addExtraClassPathEntries(jars);
            return new ArrayList<File>(jars);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", e);
        }
    }

    protected String establishGroovyVersion() throws ProjectBuildingException {
        if (this.groovyVersion == null) {
            Artifact groovyDependency = this.findGroovyDependency(this.project);
            if (groovyDependency != null) {
                this.groovyVersion = groovyDependency.getVersion();
            } else {
                String grailsVersion = this.establishGrailsVersion();
                if (grailsVersion.startsWith("2.3")) {
                    this.groovyVersion = "2.1.9";
                } else {
                    this.groovyVersion = this.findGroovyVersionFromPlugin();
                    if (this.groovyVersion == null) {
                        this.groovyVersion = "2.3.3";
                    }
                }
            }
        }
        return this.groovyVersion;
    }

    protected String establishGrailsVersion() throws ProjectBuildingException {
        if (this.grailsVersion == null) {
            Artifact grailsDependency = this.findGrailsDependency(this.project);
            this.grailsVersion = grailsDependency != null ? grailsDependency.getVersion() : this.findGrailsVersionFromPlugin();
        }
        return this.grailsVersion;
    }

    private String findGrailsVersionFromPlugin() throws ProjectBuildingException {
        return this.findArtefactVersionFromPlugin("org.grails", "grails-bootstrap");
    }

    private String findGroovyVersionFromPlugin() throws ProjectBuildingException {
        return this.findArtefactVersionFromPlugin("org.codehaus.groovy", "groovy");
    }

    private String findArtefactVersionFromPlugin(String group, String name) throws ProjectBuildingException {
        MavenProject pluginProject = this.getPluginProject();
        List dependencyArtifacts = pluginProject.getDependencies();
        if (dependencyArtifacts != null) {
            for (org.apache.maven.model.Dependency d : dependencyArtifacts) {
                if (!d.getArtifactId().equals(name) || !d.getGroupId().equals(group)) continue;
                return d.getVersion();
            }
        }
        return null;
    }

    private void handleVersionSync() throws MojoExecutionException {
        Properties metadata = new Properties();
        File metadataFile = new File(this.getBasedir(), "application.properties");
        if (metadataFile.exists()) {
            FileReader reader = null;
            OutputStreamWriter writer = null;
            try {
                try {
                    reader = new FileReader(metadataFile);
                    metadata.load(reader);
                    boolean metadataModified = this.syncVersions(metadata);
                    if (metadataModified) {
                        writer = new FileWriter(metadataFile);
                        metadata.store(writer, "Grails Metadata file");
                    }
                }
                catch (IOException iOException) {
                    throw new MojoExecutionException("Failed to sync application version with Maven plugin defined version");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean syncVersions(Properties metadata) {
        Object appVersion;
        boolean result = false;
        Object grailsVersion = metadata.get(APP_GRAILS_VERSION);
        Artifact grailsDependency = this.findGrailsDependency(this.project);
        if (grailsDependency != null && !grailsDependency.getVersion().equals(grailsVersion)) {
            metadata.put(APP_GRAILS_VERSION, grailsDependency.getVersion());
            result = true;
        }
        if ((appVersion = metadata.get(APP_VERSION)) != null && !this.project.getVersion().equals(appVersion)) {
            metadata.put(APP_VERSION, this.project.getVersion());
            result = true;
        }
        return result;
    }

    private Artifact findGrailsDependency(MavenProject project) {
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Object o : dependencyArtifacts) {
            Artifact artifact = (Artifact)o;
            if (!artifact.getArtifactId().equals("grails-dependencies") || !artifact.getGroupId().equals("org.grails")) continue;
            return artifact;
        }
        return null;
    }

    private Artifact findGroovyDependency(MavenProject project) {
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Object o : dependencyArtifacts) {
            Artifact artifact = (Artifact)o;
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            if (!groupId.equals("org.codehaus.groovy") || !artifactId.equals("groovy-all") && !artifactId.equals("groovy")) continue;
            return artifact;
        }
        return null;
    }

    private void configureMavenProxy() {
        Proxy activeProxy;
        if (this.settings != null && (activeProxy = this.settings.getActiveProxy()) != null) {
            String host = activeProxy.getHost();
            int port = activeProxy.getPort();
            String username = activeProxy.getUsername();
            String password = activeProxy.getPassword();
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", String.valueOf(port));
            if (username != null) {
                System.setProperty("http.proxyUser", username);
            }
            if (password != null) {
                System.setProperty("http.proxyPassword", password);
            }
        }
    }

    private void addExtraClassPathEntries(Set<File> jars) {
        if (this.extraClasspathEntries != null) {
            String[] entriesArr = this.extraClasspathEntries.split(",");
            int i = 0;
            while (i < entriesArr.length) {
                String entry = entriesArr[i].endsWith("\\") && i < entriesArr.length - 1 ? String.valueOf(entriesArr[i]) + "," + entriesArr[++i] : entriesArr[i];
                File file = new File(entry);
                if (!file.exists()) {
                    this.getLog().warn((CharSequence)("Grails extra classpath entry " + file + " does not exist."), (Throwable)new Exception());
                }
                jars.add(file);
                ++i;
            }
        }
    }

    private void findAndAddToolsJar(Set<File> jars) {
        String javaHome = System.getProperty("java.home");
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "tools.jar");
        }
        if (toolsJar.exists() && toolsJar != null) {
            jars.add(toolsJar);
        }
    }

    private MavenProject getPluginProject() throws ProjectBuildingException {
        Artifact pluginArtifact = this.findArtifact(this.project.getPluginArtifacts(), "org.grails", "grails-maven-plugin");
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setLocalRepository(this.localRepository);
        return this.projectBuilder.build(pluginArtifact, (ProjectBuildingRequest)request).getProject();
    }

    private Artifact findArtifact(Collection<Artifact> artifacts, String groupId, String artifactId) {
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }
}

