/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin.tools;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.groovy.grails.io.support.FileSystemResource;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.AstPluginDescriptorReader;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.grails.maven.plugin.tools.GrailsPluginProject;
import org.grails.maven.plugin.tools.GrailsProject;
import org.grails.maven.plugin.tools.GrailsServices;

public class DefaultGrailsServices
extends AbstractLogEnabled
implements GrailsServices {
    private static final String FILE_SUFFIX = "GrailsPlugin.groovy";
    private File _basedir;
    private static final String CAMEL_CASE_CONVERSION = "([a-z0-9])(?=[A-Z])";

    public static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        String[] tokens;
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.indexOf(45) == -1) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = tokens = name.split("-");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token != null && token.length() != 0) {
                buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
            }
            ++n2;
        }
        return buf.toString();
    }

    public static String getLowerCaseHyphenSeparatedName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.replaceAll(CAMEL_CASE_CONVERSION, "$1-").toLowerCase();
    }

    private File getBasedir() {
        if (this._basedir != null) {
            return this._basedir;
        }
        throw new RuntimeException("The basedir has to be set before any of the service methods are invoked.");
    }

    @Override
    public void setBasedir(File basedir) {
        this._basedir = basedir;
    }

    @Override
    public GrailsProject readProjectDescriptor() throws MojoExecutionException {
        GrailsProject grailsProject;
        FileInputStream fis = null;
        try {
            Properties properties = new Properties();
            fis = new FileInputStream(new File(this.getBasedir(), "application.properties"));
            properties.load(fis);
            GrailsProject grailsProject2 = new GrailsProject();
            grailsProject2.setAppGrailsVersion(properties.getProperty("app.grails.version"));
            grailsProject2.setAppName(properties.getProperty("app.name"));
            grailsProject2.setAppVersion(properties.getProperty("app.version"));
            grailsProject = grailsProject2;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to read grails project descriptor.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fis);
        return grailsProject;
    }

    @Override
    public void writeProjectDescriptor(File projectDir, GrailsProject grailsProjectDescriptor) throws MojoExecutionException {
        String description = "Grails Descriptor updated by grails-maven-plugin on " + new Date();
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(new File(projectDir, "application.properties"));
                Properties properties = new Properties();
                properties.setProperty("app.grails.version", grailsProjectDescriptor.getAppGrailsVersion());
                properties.setProperty("app.name", grailsProjectDescriptor.getAppName());
                properties.setProperty("app.version", grailsProjectDescriptor.getAppVersion());
                properties.store(fos, description);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write grails project descriptor.", (Exception)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((OutputStream)fos);
    }

    @Override
    public GrailsPluginProject readGrailsPluginProject() throws MojoExecutionException {
        GrailsPluginProject pluginProject = new GrailsPluginProject();
        File[] files = this.getBasedir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(DefaultGrailsServices.FILE_SUFFIX) && s.length() > DefaultGrailsServices.FILE_SUFFIX.length();
            }
        });
        if (files == null || files.length != 1) {
            throw new MojoExecutionException("Could not find a plugin descriptor. Expected to find exactly one file called FooGrailsPlugin.groovy in '" + this.getBasedir().getAbsolutePath() + "'.");
        }
        File descriptor = files[0];
        pluginProject.setFileName(descriptor);
        String className = descriptor.getName().substring(0, descriptor.getName().length() - ".groovy".length());
        String pluginName = DefaultGrailsServices.getLowerCaseHyphenSeparatedName(DefaultGrailsServices.getLogicalName(className, "GrailsPlugin"));
        pluginProject.setPluginName(pluginName);
        GroovyClassLoader classLoader = new GroovyClassLoader();
        AstPluginDescriptorReader reader = new AstPluginDescriptorReader(classLoader);
        GrailsPluginInfo info = reader.readPluginInfo((Resource)new FileSystemResource(descriptor));
        String version = info.getVersion();
        if (version == null || version.trim().length() == 0) {
            throw new MojoExecutionException("Plugin does not have a version!");
        }
        pluginProject.setVersion(version);
        return pluginProject;
    }

    public static String getLogicalName(String name, String trailingName) {
        if (trailingName == null || trailingName.length() == 0) {
            return DefaultGrailsServices.getShortName(name);
        }
        String shortName = DefaultGrailsServices.getShortName(name);
        if (shortName.indexOf(trailingName) == -1) {
            return name;
        }
        return shortName.substring(0, shortName.length() - trailingName.length());
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }
}

