/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.credential.impl;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.bouncycastle.openssl.PasswordFinder;
import org.italiangrid.voms.credential.LoadCredentialsEventListener;
import org.italiangrid.voms.credential.LoadCredentialsStrategy;
import org.italiangrid.voms.credential.VOMSEnvironmentVariables;
import org.italiangrid.voms.util.FilePermissionHelper;

public abstract class AbstractLoadCredentialsStrategy
implements LoadCredentialsStrategy,
VOMSEnvironmentVariables {
    LoadCredentialsEventListener listener;

    protected AbstractLoadCredentialsStrategy(LoadCredentialsEventListener listener) {
        this.listener = listener;
    }

    protected boolean fileExistsAndIsReadable(String filename) {
        File f = new File(filename);
        return f.exists() && f.isFile() && f.canRead();
    }

    protected X509Credential loadPEMCredential(String privateKeyPath, String certificatePath, PasswordFinder pf) {
        PEMCredential cred = null;
        this.listener.notifyCredentialLookup(privateKeyPath, certificatePath);
        try {
            FilePermissionHelper.checkPrivateKeyPermissions(privateKeyPath);
            cred = new PEMCredential((InputStream)new FileInputStream(privateKeyPath), (InputStream)new FileInputStream(certificatePath), pf);
            this.listener.notifyLoadCredentialSuccess(privateKeyPath, certificatePath);
        }
        catch (Throwable t) {
            this.listener.notifyLoadCredentialFailure(t, privateKeyPath, certificatePath);
        }
        return cred;
    }

    protected X509Credential loadPKCS12Credential(String pkcs12FilePath, PasswordFinder pf) {
        KeystoreCredential cred = null;
        this.listener.notifyCredentialLookup(pkcs12FilePath);
        if (this.fileExistsAndIsReadable(pkcs12FilePath)) {
            char[] keyPassword = pf.getPassword();
            try {
                FilePermissionHelper.checkPKCS12Permissions(pkcs12FilePath);
                cred = new KeystoreCredential(pkcs12FilePath, keyPassword, keyPassword, null, "PKCS12");
                this.listener.notifyLoadCredentialSuccess(pkcs12FilePath);
            }
            catch (Throwable t) {
                this.listener.notifyLoadCredentialFailure(t, pkcs12FilePath);
            }
        } else {
            this.listener.notifyLoadCredentialFailure(new FileNotFoundException(pkcs12FilePath + " (cannot read file)"), pkcs12FilePath);
        }
        return cred;
    }

    protected X509Credential loadProxyCredential(String proxyPath) {
        PEMCredential cred = null;
        this.listener.notifyCredentialLookup(proxyPath);
        try {
            FilePermissionHelper.checkProxyPermissions(proxyPath);
            cred = new PEMCredential((InputStream)new FileInputStream(proxyPath), (char[])null);
            this.listener.notifyLoadCredentialSuccess(proxyPath);
        }
        catch (Throwable t) {
            this.listener.notifyLoadCredentialFailure(t, proxyPath);
        }
        return cred;
    }
}

