/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.italiangrid.voms.util.FilePermissionHelper;

public class CredentialsUtils {
    public static final PrivateKeyEncoding DEFAULT_ENCONDING = PrivateKeyEncoding.PKCS_1;

    public static void savePrivateKey(OutputStream os, PrivateKey key, PrivateKeyEncoding encoding) throws IllegalArgumentException, IOException {
        switch (encoding) {
            case PKCS_1: {
                CredentialsUtils.savePrivateKeyPKCS1(os, key);
                break;
            }
            case PKCS_8: {
                CredentialsUtils.savePrivateKeyPKCS8(os, key);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported private key encoding: " + encoding.name());
            }
        }
    }

    private static void savePrivateKeyPKCS8(OutputStream os, PrivateKey key) throws IllegalArgumentException, IOException {
        CertificateUtils.savePrivateKey((OutputStream)os, (PrivateKey)key, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null, null);
    }

    private static void savePrivateKeyPKCS1(OutputStream os, PrivateKey key) throws IllegalArgumentException, IOException {
        CertificateUtils.savePrivateKey((OutputStream)os, (PrivateKey)key, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null, (char[])new char[0], (boolean)true);
    }

    public static void saveProxyCredentials(OutputStream os, X509Credential uc, PrivateKeyEncoding encoding) throws UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        X509Certificate[] chain = CertificateHelpers.sortChain(Arrays.asList(uc.getCertificateChain()));
        PrivateKey key = uc.getKey();
        X509Certificate cert = uc.getCertificate();
        CertificateUtils.saveCertificate((OutputStream)os, (X509Certificate)cert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        if (key != null) {
            CredentialsUtils.savePrivateKey(os, key, encoding);
        }
        X509Certificate c = null;
        for (int index = 1; index < chain.length; ++index) {
            c = chain[index];
            int basicConstraints = c.getBasicConstraints();
            if (basicConstraints >= 0) continue;
            CertificateUtils.saveCertificate((OutputStream)os, (X509Certificate)c, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        }
        os.flush();
    }

    public static void saveProxyCredentials(OutputStream os, X509Credential uc) throws UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        CredentialsUtils.saveProxyCredentials(os, uc, DEFAULT_ENCONDING);
    }

    public static void saveProxyCredentials(String proxyFileName, X509Credential uc, PrivateKeyEncoding encoding) throws IOException, UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        File f = new File(proxyFileName);
        RandomAccessFile raf = new RandomAccessFile(f, "rws");
        FileChannel channel = raf.getChannel();
        FilePermissionHelper.setProxyPermissions(proxyFileName);
        channel.truncate(0L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CredentialsUtils.saveProxyCredentials(baos, uc, encoding);
        baos.close();
        channel.write(ByteBuffer.wrap(baos.toByteArray()));
        channel.close();
        raf.close();
    }

    public static void saveProxyCredentials(String proxyFileName, X509Credential uc) throws UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, IOException {
        CredentialsUtils.saveProxyCredentials(proxyFileName, uc, DEFAULT_ENCONDING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrivateKeyEncoding {
        PKCS_1,
        PKCS_8;

    }
}

