/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import javax.money.convert.ExchangeRateProvider;
import org.javamoney.moneta.convert.ExchangeCurrencyOperator;
import org.javamoney.moneta.convert.ExchangeRateMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

public final class ConversionOperators {
    private ConversionOperators() {
    }

    public static MonetaryOperator exchange(CurrencyUnit currencyUnit) {
        return new ExchangeCurrencyOperator(Objects.requireNonNull(currencyUnit));
    }

    public static Collector<MonetaryAmount, MonetarySummaryStatistics, MonetarySummaryStatistics> summarizingMonetary(CurrencyUnit currencyUnit, ExchangeRateProvider provider) {
        Supplier<MonetarySummaryStatistics> supplier = () -> new ExchangeRateMonetarySummaryStatistics(currencyUnit, provider);
        return Collector.of(supplier, MonetarySummaryStatistics::accept, MonetarySummaryStatistics::combine, new Collector.Characteristics[0]);
    }
}

