/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls.jmx;

import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.ShrinkWrapUtil;
import org.jboss.arquillian.container.wls.WebLogicJMXClient;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullJMXRemoteContainer {
    private WebLogicJMXClient jmxClient;
    private CommonWebLogicConfiguration configuration;

    public FullJMXRemoteContainer(CommonWebLogicConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        this.jmxClient = new WebLogicJMXClient(this.configuration);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        return this.jmxClient.deploy(this.getDeploymentName(archive), ShrinkWrapUtil.toFile(archive, this.configuration.isDeployExplodedArchive()));
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.jmxClient.undeploy(this.getDeploymentName(archive));
    }

    public void stop() throws LifecycleException {
        this.jmxClient.close();
    }

    private String getDeploymentName(Archive<?> archive) {
        String archiveFilename = archive.getName();
        int indexOfDot = archiveFilename.indexOf(".");
        if (indexOfDot != -1) {
            return archiveFilename.substring(0, indexOfDot);
        }
        return archiveFilename;
    }
}

