/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.util.Objects;

public class SlotStoreKey {
    private final Uid uid;
    private final String typeName;
    private final int stateStatus;
    private final int hashcode;

    public SlotStoreKey(Uid uid, String typeName, int stateStatus) {
        if (!typeName.startsWith("/")) {
            typeName = "/" + typeName;
        }
        this.uid = uid == null ? Uid.nullUid() : uid;
        this.typeName = typeName;
        this.stateStatus = stateStatus;
        this.hashcode = Objects.requireNonNull(uid).hashCode();
    }

    public Uid getUid() {
        return this.uid;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getStateStatus() {
        return this.stateStatus;
    }

    public void packInto(OutputBuffer outputBuffer) throws IOException {
        UidHelper.packInto(this.uid, outputBuffer);
        outputBuffer.packString(this.typeName);
        outputBuffer.packInt(this.stateStatus);
    }

    public static SlotStoreKey unpackFrom(InputBuffer inputBuffer) throws IOException {
        Uid uid = UidHelper.unpackFrom(inputBuffer);
        String typeName = inputBuffer.unpackString();
        int stateStatus = inputBuffer.unpackInt();
        return new SlotStoreKey(uid, typeName, stateStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotStoreKey key = (SlotStoreKey)o;
        return this.stateStatus == key.stateStatus && Objects.equals(this.uid, key.uid) && Objects.equals(this.typeName, key.typeName);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

