/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DispatcherUtilities {
    private ResteasyProviderFactory providerFactory;
    private Registry registry;

    public DispatcherUtilities(ResteasyProviderFactory providerFactory, Registry registry) {
        this.providerFactory = providerFactory;
        this.registry = registry;
    }

    public MediaType resolveContentType(Response jaxrsResponse) {
        MediaType responseContentType = null;
        Object type = jaxrsResponse.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public void outputHeaders(HttpResponse response, Response jaxrsResponse) {
        response.setStatus(jaxrsResponse.getStatus());
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll((Map)jaxrsResponse.getMetadata());
        }
    }

    public void outputCookies(HttpResponse response, Response jaxrsResponse) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
    }

    public void pushContextObjects(HttpRequest request, HttpResponse response) {
        ResteasyProviderFactory.pushContext(HttpRequest.class, request);
        ResteasyProviderFactory.pushContext(HttpResponse.class, response);
        ResteasyProviderFactory.pushContext(HttpHeaders.class, request.getHttpHeaders());
        ResteasyProviderFactory.pushContext(UriInfo.class, request.getUri());
        ResteasyProviderFactory.pushContext(Request.class, new RequestImpl(request));
        ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        ResteasyProviderFactory.pushContext(Registry.class, this.registry);
    }

    public ResponseInvoker resolveResponseInvoker(HttpResponse response, Response jaxrsResponse) {
        this.outputCookies(response, jaxrsResponse);
        ResponseInvoker responseInvoker = null;
        if (jaxrsResponse.getEntity() == null) {
            this.outputHeaders(response, jaxrsResponse);
        } else {
            responseInvoker = this.createResponseInvoker(jaxrsResponse);
            if (responseInvoker.getWriter() == null) {
                throw new NoMessageBodyWriterFoundFailure(responseInvoker);
            }
            this.outputHeaders(response, jaxrsResponse);
            this.outputSizeHeader(response, responseInvoker);
        }
        return responseInvoker;
    }

    public ResponseInvoker createResponseInvoker(Response jaxrsResponse) {
        return new ResponseInvoker(jaxrsResponse, this.resolveContentType(jaxrsResponse), this.getProviderFactory());
    }

    private void outputSizeHeader(HttpResponse response, ResponseInvoker responseInvoker) {
        long size;
        if (responseInvoker != null && (size = responseInvoker.getResponseSize()) > -1L) {
            response.getOutputHeaders().putSingle((Object)"Content-Length", (Object)String.valueOf(size));
        }
    }

    public Response getJaxrsResponse(HttpRequest request, HttpResponse response, ResourceInvoker invoker) throws Exception {
        Response jaxrsResponse = invoker.invoke(request, response);
        if (request.isSuspended()) {
            request.initialRequestThreadFinished();
            return null;
        }
        return jaxrsResponse;
    }

    public void clearContextData() {
        ResteasyProviderFactory.clearContextData();
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }
}

