/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLocator
implements ResourceInvoker {
    static final Logger logger = LoggerFactory.getLogger(ResourceLocator.class);
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected ConcurrentHashMap<Class, Registry> cachedSubresources = new ConcurrentHashMap();

    public ResourceLocator(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, Class root, Method method) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(root, method);
    }

    protected Object createResource(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.injector);
        return this.createResource(request, response, resource);
    }

    protected Object createResource(HttpRequest request, HttpResponse response, Object locator) {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        Object[] args = this.methodInjector.injectArguments(request, response);
        try {
            uriInfo.pushCurrentResource(locator);
            Object subResource = this.method.invoke(locator, args);
            this.warnIfJaxRSAnnotatedFields(subResource);
            return subResource;
        }
        catch (IllegalAccessException e) {
            throw new LoggableFailure(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationException(e.getCause());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(HttpRequest request, HttpResponse response) {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        try {
            Object target = this.createResource(request, response);
            Response response2 = this.invokeOnTargetObject(request, response, target);
            return response2;
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popMatchedURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(HttpRequest request, HttpResponse response, Object locator) {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        try {
            Object target = this.createResource(request, response, locator);
            Response response2 = this.invokeOnTargetObject(request, response, target);
            return response2;
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popMatchedURI();
        }
    }

    protected Response invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) {
        ResourceInvoker invoker;
        if (target == null) {
            throw new Failure("Null subresource for path: " + request.getUri().getAbsolutePath(), 404);
        }
        Registry registry = this.cachedSubresources.get(target.getClass());
        if (registry == null) {
            registry = new ResourceMethodRegistry(this.providerFactory);
            Class subResourceClass = GetRestful.getSubResourceClass(target.getClass());
            if (subResourceClass == null) {
                String msg = "Subresource for target class has no jax-rs annotations.: " + target.getClass().getName();
                throw new LoggableFailure(msg, 500);
            }
            registry.addResourceFactory(null, null, subResourceClass);
            this.cachedSubresources.putIfAbsent(target.getClass(), registry);
        }
        if ((invoker = registry.getResourceInvoker(request, response)) == null) {
            throw new Failure("No path match in subresource for: " + request.getUri().getAbsolutePath(), 404);
        }
        if (invoker instanceof ResourceLocator) {
            ResourceLocator locator = (ResourceLocator)invoker;
            return locator.invoke(request, response, target);
        }
        ResourceMethod method = (ResourceMethod)invoker;
        return method.invoke(request, response, target);
    }

    private void warnIfJaxRSAnnotatedFields(Object obj) {
        if (obj == null) {
            return;
        }
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<? extends Annotation>[] annotations = FindAnnotation.findJaxRSAnnotations(field.getDeclaredAnnotations());
                if (annotations.length == 0) continue;
                logger.warn("Field '{}' of subresource '{}' will not be injected according to spec", (Object)field.getName(), (Object)obj.getClass().getName());
            }
        }
    }
}

