/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.interception.ResourceMethodContext;
import org.jboss.resteasy.core.interception.ResourceMethodInterceptor;
import org.jboss.resteasy.specimpl.ResponseImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.Types;
import org.jboss.resteasy.util.WeightedMediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethod
implements ResourceInvoker {
    protected MediaType[] produces;
    protected MediaType[] consumes;
    protected List<WeightedMediaType> preferredProduces = new ArrayList<WeightedMediaType>();
    protected List<WeightedMediaType> preferredConsumes = new ArrayList<WeightedMediaType>();
    protected Set<String> httpMethods;
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected Class<?> resourceClass;
    protected ResourceMethodInterceptor[] interceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected Type genericReturnType;

    public ResourceMethod(Class<?> clazz, Method method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory, Set<String> httpMethods) {
        int i;
        Consumes c;
        this.injector = injector;
        this.resource = resource;
        this.providerFactory = providerFactory;
        this.httpMethods = httpMethods;
        this.resourceClass = clazz;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(clazz, method);
        Produces p = method.getAnnotation(Produces.class);
        if (p == null) {
            p = clazz.getAnnotation(Produces.class);
        }
        if ((c = method.getAnnotation(Consumes.class)) == null) {
            c = clazz.getAnnotation(Consumes.class);
        }
        if (p != null) {
            this.produces = new MediaType[p.value().length];
            i = 0;
            for (String mediaType : p.value()) {
                this.produces[i++] = MediaType.valueOf((String)mediaType);
                this.preferredProduces.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        if (c != null) {
            this.consumes = new MediaType[c.value().length];
            i = 0;
            for (String mediaType : c.value()) {
                this.consumes[i++] = MediaType.valueOf((String)mediaType);
                this.preferredConsumes.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        Collections.sort(this.preferredProduces);
        Collections.sort(this.preferredConsumes);
        this.interceptors = providerFactory.getInterceptorRegistry().bind(this);
        if (this.interceptors != null && this.interceptors.length == 0) {
            this.interceptors = null;
        }
        this.genericReturnType = Types.getGenericReturnTypeOfGenericInterfaceMethod(clazz, method);
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<WeightedMediaType> getPreferredProduces() {
        return this.preferredProduces;
    }

    public List<WeightedMediaType> getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Response invoke(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.injector);
        return this.invoke(request, response, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke(HttpRequest request, HttpResponse response, Object target) {
        this.incrementMethodCount(request.getHttpMethod());
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        uriInfo.pushCurrentResource(target);
        try {
            Object type;
            Response jaxrsResponse = null;
            jaxrsResponse = this.interceptors == null || this.interceptors.length == 0 ? this.invokeOnTarget(request, response, target) : new ResourceContext(request, response, target).proceed();
            if (jaxrsResponse != null && jaxrsResponse.getEntity() != null && (type = jaxrsResponse.getMetadata().getFirst((Object)"Content-Type")) == null) {
                jaxrsResponse.getMetadata().putSingle((Object)"Content-Type", (Object)this.resolveContentType(request));
            }
            Response response2 = jaxrsResponse;
            return response2;
        }
        finally {
            uriInfo.popCurrentResource();
        }
    }

    protected Response invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        Object rtn = this.methodInjector.invoke(request, response, target);
        if (request.isSuspended()) {
            return null;
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            return (Response)rtn;
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            return Response.noContent().build();
        }
        Response.ResponseBuilder builder = null;
        builder = rtn == null ? Response.noContent() : Response.ok((Object)rtn);
        builder.type(this.resolveContentType(request));
        ResponseImpl jaxrsResponse = (ResponseImpl)builder.build();
        jaxrsResponse.setGenericType(this.genericReturnType);
        jaxrsResponse.setAnnotations(this.method.getAnnotations());
        return jaxrsResponse;
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.produces == null || this.produces.length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (WeightedMediaType type : this.preferredProduces) {
                if (!type.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (contentType == null) {
            matches = true;
        } else if (this.consumes == null || this.consumes.length == 0) {
            matches = true;
        } else {
            for (WeightedMediaType type : this.preferredConsumes) {
                if (!type.isCompatible(contentType)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    protected MediaType resolveContentType(HttpRequest in) {
        MediaType responseContentType = this.matchByType(in.getHttpHeaders().getAcceptableMediaTypes());
        if (responseContentType == null) {
            responseContentType = MediaType.valueOf((String)"*/*");
        }
        return responseContentType;
    }

    public MediaType matchByType(List<MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            if (this.produces == null) {
                return MediaType.valueOf((String)"*/*");
            }
            return this.produces[0];
        }
        if (this.produces == null || this.produces.length == 0) {
            return accepts.get(0);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.produces) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return null;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public MediaType[] getProduces() {
        return this.produces;
    }

    public MediaType[] getConsumes() {
        return this.consumes;
    }

    protected class ResourceContext
    implements ResourceMethodContext {
        protected HttpRequest request;
        protected HttpResponse response;
        protected Object target;
        protected int index;

        public ResourceContext(HttpRequest request, HttpResponse response, Object target) {
            this.request = request;
            this.response = response;
            this.target = target;
        }

        public HttpRequest getRequest() {
            return null;
        }

        public void setRequest(HttpRequest request) {
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public ResourceMethod getMethod() {
            return ResourceMethod.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response proceed() throws Failure, WebApplicationException, ApplicationException {
            if (this.index >= ResourceMethod.this.interceptors.length) {
                return ResourceMethod.this.invokeOnTarget(this.request, this.response, this.target);
            }
            try {
                Response response = ResourceMethod.this.interceptors[this.index++].invoke(this);
                return response;
            }
            finally {
                --this.index;
            }
        }
    }
}

