/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.resourcefactory;

import java.lang.reflect.Constructor;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOResourceFactory
implements ResourceFactory {
    private Class<?> scannableClass;
    private ConstructorInjector constructorInjector;
    private PropertyInjector propertyInjector;

    public POJOResourceFactory(Class<?> scannableClass) {
        this.scannableClass = scannableClass;
    }

    @Override
    public void registered(InjectorFactory factory) {
        Constructor<?> constructor = this.scannableClass.getDeclaredConstructors()[0];
        this.constructorInjector = factory.createConstructor(constructor);
        this.propertyInjector = factory.createPropertyInjector(this.scannableClass);
    }

    @Override
    public Object createResource(HttpRequest request, HttpResponse response, InjectorFactory factory) {
        Object obj = this.constructorInjector.construct(request, response);
        this.propertyInjector.inject(request, response, obj);
        return obj;
    }

    @Override
    public void unregistered() {
    }

    @Override
    public Class<?> getScannableClass() {
        return this.scannableClass;
    }

    @Override
    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }
}

