/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPortProvider {
    private static final int DEFAULT_PORT = 8081;
    private static final String ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PROPERTY_NAME = "org.jboss.resteasy.port";

    public static ClientRequest createClientRequest(String path) {
        return new ClientRequest(TestPortProvider.generateURL(path));
    }

    public static DeleteMethod createDeleteMethod(String path) {
        return new DeleteMethod(TestPortProvider.generateURL(path));
    }

    public static GetMethod createGetMethod(String path) {
        return new GetMethod(TestPortProvider.generateURL(path));
    }

    public static OptionsMethod createOptionsMethod(String path) {
        return new OptionsMethod(TestPortProvider.generateURL(path));
    }

    public static PostMethod createPostMethod(String path) {
        return new PostMethod(TestPortProvider.generateURL(path));
    }

    public static <T> T createProxy(Class<T> clazz) {
        return TestPortProvider.createProxy(clazz, "");
    }

    public static <T> T createProxy(Class<T> clazz, String path) {
        return ProxyFactory.create(clazz, TestPortProvider.generateURL(path));
    }

    public static PutMethod createPutMethod(String path) {
        return new PutMethod(TestPortProvider.generateURL(path));
    }

    public static URI createURI(String path) {
        return URI.create(TestPortProvider.generateURL(path));
    }

    public static URL createURL(String path) throws MalformedURLException {
        return new URL(TestPortProvider.generateURL(path));
    }

    public static String generateBaseUrl() {
        return TestPortProvider.generateURL("");
    }

    public static String generateURL(String path) {
        return String.format("http://localhost:%d%s", TestPortProvider.getPort(), path);
    }

    public static int getPort() {
        int port = -1;
        String property = System.getenv(ENV_VAR_NAME);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (port == -1 && (property = System.getProperty(PROPERTY_NAME)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = 8081;
        }
        return port;
    }
}

