/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.js.resolve

import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator
import org.jetbrains.kotlin.types.KotlinType
import org.jetbrains.kotlin.types.isDynamic
import org.jetbrains.kotlin.types.isFlexible
import org.jetbrains.kotlin.types.model.KotlinTypeMarker
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContextDelegate

// Replacing the TypeSystemInferenceExtensionContextDelegate with
// TypeSystemInferenceExtensionContext here leads to clashed registrations
// (for example, when trying to run IrJsTextTestCaseGenerated).
class JsTypeSpecificityComparator(context: TypeSystemInferenceExtensionContextDelegate) :
    TypeSpecificityComparator by JsTypeSpecificityComparatorWithoutDelegate(context)

class JsTypeSpecificityComparatorWithoutDelegate(val context: TypeSystemInferenceExtensionContext) : TypeSpecificityComparator {
    private fun TypeSystemInferenceExtensionContext.checkOnlyDynamicFlexibleType(type: KotlinTypeMarker) {
        if (type.asFlexibleType() != null) {
            assert(type.isDynamic()) {
                "Unexpected flexible type in Js: $type"
            }
        }
    }

    override fun isDefinitelyLessSpecific(specific: KotlinTypeMarker, general: KotlinTypeMarker): Boolean = with(context) {
        checkOnlyDynamicFlexibleType(specific)
        checkOnlyDynamicFlexibleType(general)

        return specific.isDynamic() && !general.isDynamic()
    }
}