/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicHttpContext
implements HttpContext {
    private final HttpContext parentContext;
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    public BasicHttpContext() {
        this(null);
    }

    public BasicHttpContext(HttpContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public Object getAttribute(String id) {
        Args.notNull(id, "Id");
        Object obj2 = this.map.get(id);
        if (obj2 == null && this.parentContext != null) {
            obj2 = this.parentContext.getAttribute(id);
        }
        return obj2;
    }

    @Override
    public void setAttribute(String id, Object obj2) {
        Args.notNull(id, "Id");
        if (obj2 != null) {
            this.map.put(id, obj2);
        } else {
            this.map.remove(id);
        }
    }

    @Override
    public Object removeAttribute(String id) {
        Args.notNull(id, "Id");
        return this.map.remove(id);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

