/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.VersionUtil;
import org.globus.gsi.X509Credential;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.GlobusProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.globus.util.I18n;

public class BouncyCastleCertProcessingFactory {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", BouncyCastleCertProcessingFactory.class.getClassLoader());
    private static BouncyCastleCertProcessingFactory factory;

    protected BouncyCastleCertProcessingFactory() {
    }

    public static synchronized BouncyCastleCertProcessingFactory getDefault() {
        if (factory == null) {
            factory = new BouncyCastleCertProcessingFactory();
        }
        return factory;
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, (X509ExtensionSet)null, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, X509ExtensionSet extSet) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, extSet, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, X509ExtensionSet extSet, String cnValue) throws IOException, GeneralSecurityException {
        ASN1InputStream derin = new ASN1InputStream(certRequestInputStream);
        ASN1Primitive reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((ASN1Sequence)reqInfo);
        boolean rs = certReq.verify();
        if (!rs) {
            String err = i18n.getMessage("certReqVerification");
            throw new GeneralSecurityException(err);
        }
        return this.createProxyCertificate(cert, privateKey, certReq.getPublicKey(), lifetime, delegationMode, extSet, cnValue);
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, (X509ExtensionSet)null, null);
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, X509ExtensionSet extSet) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, extSet, null);
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, X509ExtensionSet extSet, String cnValue) throws GeneralSecurityException {
        X509Certificate[] bcCerts = this.getX509CertificateObjectChain(certs);
        KeyPairGenerator keyGen = null;
        keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(bits);
        KeyPair keyPair = keyGen.genKeyPair();
        X509Certificate newCert = this.createProxyCertificate(bcCerts[0], privateKey, keyPair.getPublic(), lifetime, delegationMode, extSet, cnValue);
        X509Certificate[] newCerts = new X509Certificate[bcCerts.length + 1];
        newCerts[0] = newCert;
        System.arraycopy(certs, 0, newCerts, 1, certs.length);
        return new GlobusCredential(keyPair.getPrivate(), newCerts);
    }

    /*
     * Unable to fully structure code
     */
    public X509Certificate createProxyCertificate(X509Certificate issuerCert_, PrivateKey issuerKey, PublicKey publicKey, int lifetime, int proxyType, X509ExtensionSet extSet, String cnValue) throws GeneralSecurityException {
        issuerCert = issuerCert_;
        if (!(issuerCert_ instanceof X509CertificateObject)) {
            issuerCert = CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(issuerCert.getEncoded()));
        }
        if (proxyType == 2) {
            type = BouncyCastleUtil.getCertificateType(issuerCert);
            proxyType = ProxyCertificateUtil.isGsi4Proxy(type) ? 19 : (ProxyCertificateUtil.isGsi3Proxy(type) ? 15 : (ProxyCertificateUtil.isGsi2Proxy(type) ? 11 : (VersionUtil.isGsi2Enabled() ? 11 : (VersionUtil.isGsi3Enabled() != false ? 15 : 19))));
        } else if (proxyType == 3) {
            type = BouncyCastleUtil.getCertificateType(issuerCert);
            proxyType = ProxyCertificateUtil.isGsi4Proxy(type) != false ? 18 : (ProxyCertificateUtil.isGsi3Proxy(type) != false ? 14 : (ProxyCertificateUtil.isGsi2Proxy(type) != false ? 10 : (VersionUtil.isGsi2Enabled() != false ? 10 : (VersionUtil.isGsi3Enabled() != false ? 14 : 18))));
        }
        certGen = new X509V3CertificateGenerator();
        x509Ext = null;
        serialNum = null;
        delegDN = null;
        if (ProxyCertificateUtil.isGsi3Proxy(GSIConstants.CertificateType.get(proxyType)) || ProxyCertificateUtil.isGsi4Proxy(GSIConstants.CertificateType.get(proxyType))) {
            rand = new Random();
            delegDN = String.valueOf(Math.abs(rand.nextInt()));
            serialNum = new BigInteger(20, rand);
            if (extSet != null && (x509Ext = extSet.get(ProxyCertInfo.OID.getId())) == null) {
                x509Ext = extSet.get(ProxyCertInfo.OLD_OID.getId());
            }
            if (x509Ext == null) {
                policy = null;
                if (ProxyCertificateUtil.isLimitedProxy(GSIConstants.CertificateType.get(proxyType))) {
                    policy = new ProxyPolicy(ProxyPolicy.LIMITED);
                } else if (ProxyCertificateUtil.isIndependentProxy(GSIConstants.CertificateType.get(proxyType))) {
                    policy = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
                } else if (ProxyCertificateUtil.isImpersonationProxy(GSIConstants.CertificateType.get(proxyType))) {
                    policy = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
                } else {
                    if (proxyType == 12 || proxyType == 16) {
                        err = BouncyCastleCertProcessingFactory.i18n.getMessage("restrictProxy");
                        throw new IllegalArgumentException(err);
                    }
                    err = BouncyCastleCertProcessingFactory.i18n.getMessage("invalidProxyType");
                    throw new IllegalArgumentException(err);
                }
                proxyCertInfo = new ProxyCertInfo(policy);
                x509Ext = new ProxyCertInfoExtension(proxyCertInfo);
                x509Ext = ProxyCertificateUtil.isGsi4Proxy(GSIConstants.CertificateType.get(proxyType)) != false ? new ProxyCertInfoExtension(proxyCertInfo) : new GlobusProxyCertInfoExtension(proxyCertInfo);
            }
            try {
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
                crt = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                extensions = crt.getExtensions();
                if (extensions == null || (ext = extensions.getExtension(X509Extension.keyUsage)) == null) ** GOTO lbl69
                if (extSet != null && extSet.get(X509Extension.keyUsage.getId()) != null) {
                    err = BouncyCastleCertProcessingFactory.i18n.getMessage("keyUsageExt");
                    throw new GeneralSecurityException(err);
                }
                bits = (DERBitString)BouncyCastleUtil.getExtensionObject(ext);
                bytes = bits.getBytes();
                if ((bytes[0] & 64) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 64);
                }
                if ((bytes[0] & 4) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 4);
                }
                bits = new DERBitString(bytes, bits.getPadBits());
                certGen.addExtension((DERObjectIdentifier)X509Extension.keyUsage, ext.isCritical(), (ASN1Encodable)bits);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        } else if (proxyType == 11) {
            delegDN = "limited proxy";
            serialNum = issuerCert.getSerialNumber();
        } else if (proxyType == 10) {
            delegDN = "proxy";
            serialNum = issuerCert.getSerialNumber();
        } else {
            err = BouncyCastleCertProcessingFactory.i18n.getMessage("unsupportedProxy", Integer.toString(proxyType));
            throw new IllegalArgumentException(err);
        }
lbl69:
        // 4 sources

        if (extSet != null) {
            for (String oid : extSet.oidSet()) {
                if (oid.equals(ProxyCertInfo.OID.getId()) || oid.equals(ProxyCertInfo.OLD_OID.getId())) continue;
                x509Ext = extSet.get(oid);
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
            }
        }
        issuerDN = issuerCert.getSubjectDN() instanceof X509Name != false ? (X509Name)issuerCert.getSubjectDN() : new X509Name(true, issuerCert.getSubjectX500Principal().getName());
        issuer = new X509NameHelper(issuerDN);
        subject = new X509NameHelper(issuerDN);
        subject.add((DERObjectIdentifier)BCStyle.CN, cnValue == null ? delegDN : cnValue);
        certGen.setSubjectDN(subject.getAsName());
        certGen.setIssuerDN(issuer.getAsName());
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(issuerCert.getSigAlgName());
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime <= 0) {
            certGen.setNotAfter(issuerCert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            certGen.setNotAfter(date.getTime());
        }
        return certGen.generateX509Certificate(issuerKey);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, GSIConstants.CertificateType certType) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, certType, (X509ExtensionSet)null, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, GSIConstants.CertificateType certType, X509ExtensionSet extSet) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, certType, extSet, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, GSIConstants.CertificateType certType, X509ExtensionSet extSet, String cnValue) throws IOException, GeneralSecurityException {
        ASN1InputStream derin = new ASN1InputStream(certRequestInputStream);
        ASN1Primitive reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((ASN1Sequence)reqInfo);
        boolean rs = certReq.verify();
        if (!rs) {
            String err = i18n.getMessage("certReqVerification");
            throw new GeneralSecurityException(err);
        }
        return this.createProxyCertificate(cert, privateKey, certReq.getPublicKey(), lifetime, certType, extSet, cnValue);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.CertificateType certType) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, certType, (X509ExtensionSet)null, null);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.CertificateType certType, X509ExtensionSet extSet) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, certType, extSet, null);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.CertificateType certType, X509ExtensionSet extSet, String cnValue) throws GeneralSecurityException {
        X509Certificate[] bcCerts = this.getX509CertificateObjectChain(certs);
        KeyPairGenerator keyGen = null;
        keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(bits);
        KeyPair keyPair = keyGen.genKeyPair();
        X509Certificate newCert = this.createProxyCertificate(bcCerts[0], privateKey, keyPair.getPublic(), lifetime, certType, extSet, cnValue);
        X509Certificate[] newCerts = new X509Certificate[bcCerts.length + 1];
        newCerts[0] = newCert;
        System.arraycopy(certs, 0, newCerts, 1, certs.length);
        return new X509Credential(keyPair.getPrivate(), newCerts);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.DelegationType delegType) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegType, (X509ExtensionSet)null, null);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.DelegationType delegType, X509ExtensionSet extSet) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegType, extSet, null);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, GSIConstants.DelegationType delegType, X509ExtensionSet extSet, String cnValue) throws GeneralSecurityException {
        X509Certificate[] bcCerts = this.getX509CertificateObjectChain(certs);
        return this.createCredential(bcCerts, privateKey, bits, lifetime, BouncyCastleCertProcessingFactory.decideProxyType(bcCerts[0], delegType), extSet, cnValue);
    }

    /*
     * Unable to fully structure code
     */
    public X509Certificate createProxyCertificate(X509Certificate issuerCert_, PrivateKey issuerKey, PublicKey publicKey, int lifetime, GSIConstants.CertificateType certType, X509ExtensionSet extSet, String cnValue) throws GeneralSecurityException {
        issuerCert = issuerCert_;
        if (!(issuerCert_ instanceof X509CertificateObject)) {
            issuerCert = CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(issuerCert.getEncoded()));
        }
        certGen = new X509V3CertificateGenerator();
        x509Ext = null;
        serialNum = null;
        delegDN = null;
        if (ProxyCertificateUtil.isGsi3Proxy(certType) || ProxyCertificateUtil.isGsi4Proxy(certType)) {
            rand = new Random();
            delegDN = String.valueOf(Math.abs(rand.nextInt()));
            serialNum = new BigInteger(20, rand);
            if (extSet != null && (x509Ext = extSet.get(ProxyCertInfo.OID.getId())) == null) {
                x509Ext = extSet.get(ProxyCertInfo.OLD_OID.getId());
            }
            if (x509Ext == null) {
                policy = null;
                if (ProxyCertificateUtil.isLimitedProxy(certType)) {
                    policy = new ProxyPolicy(ProxyPolicy.LIMITED);
                } else if (ProxyCertificateUtil.isIndependentProxy(certType)) {
                    policy = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
                } else if (ProxyCertificateUtil.isImpersonationProxy(certType)) {
                    policy = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
                } else {
                    if (certType == GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY || certType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY) {
                        err = BouncyCastleCertProcessingFactory.i18n.getMessage("restrictProxy");
                        throw new IllegalArgumentException(err);
                    }
                    err = BouncyCastleCertProcessingFactory.i18n.getMessage("invalidProxyType");
                    throw new IllegalArgumentException(err);
                }
                proxyCertInfo = new ProxyCertInfo(policy);
                x509Ext = new ProxyCertInfoExtension(proxyCertInfo);
                x509Ext = ProxyCertificateUtil.isGsi4Proxy(certType) != false ? new ProxyCertInfoExtension(proxyCertInfo) : new GlobusProxyCertInfoExtension(proxyCertInfo);
            }
            try {
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
                crt = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                extensions = crt.getExtensions();
                if (extensions == null || (ext = extensions.getExtension(X509Extension.keyUsage)) == null) ** GOTO lbl62
                if (extSet != null && extSet.get(X509Extension.keyUsage.getId()) != null) {
                    err = BouncyCastleCertProcessingFactory.i18n.getMessage("keyUsageExt");
                    throw new GeneralSecurityException(err);
                }
                bits = (DERBitString)BouncyCastleUtil.getExtensionObject(ext);
                bytes = bits.getBytes();
                if ((bytes[0] & 64) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 64);
                }
                if ((bytes[0] & 4) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 4);
                }
                bits = new DERBitString(bytes, bits.getPadBits());
                certGen.addExtension((DERObjectIdentifier)X509Extension.keyUsage, ext.isCritical(), (ASN1Encodable)bits);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        } else if (certType == GSIConstants.CertificateType.GSI_2_LIMITED_PROXY) {
            delegDN = "limited proxy";
            serialNum = issuerCert.getSerialNumber();
        } else if (certType == GSIConstants.CertificateType.GSI_2_PROXY) {
            delegDN = "proxy";
            serialNum = issuerCert.getSerialNumber();
        } else {
            err = BouncyCastleCertProcessingFactory.i18n.getMessage("unsupportedProxy", (Object)certType);
            throw new IllegalArgumentException(err);
        }
lbl62:
        // 4 sources

        if (extSet != null) {
            for (String oid : extSet.oidSet()) {
                if (oid.equals(ProxyCertInfo.OID.getId()) || oid.equals(ProxyCertInfo.OLD_OID.getId())) continue;
                x509Ext = extSet.get(oid);
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
            }
        }
        issuerDN = issuerCert.getSubjectDN() instanceof X509Name != false ? (X509Name)issuerCert.getSubjectDN() : new X509Name(true, issuerCert.getSubjectX500Principal().getName());
        issuer = new X509NameHelper(issuerDN);
        subject = new X509NameHelper(issuerDN);
        subject.add((DERObjectIdentifier)BCStyle.CN, cnValue == null ? delegDN : cnValue);
        certGen.setSubjectDN(subject.getAsName());
        certGen.setIssuerDN(issuer.getAsName());
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(issuerCert.getSigAlgName());
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime <= 0) {
            certGen.setNotAfter(issuerCert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            certGen.setNotAfter(date.getTime());
        }
        return certGen.generateX509Certificate(issuerKey);
    }

    public X509Certificate loadCertificate(InputStream in) throws IOException, GeneralSecurityException {
        ASN1InputStream derin = new ASN1InputStream(in);
        ASN1Primitive certInfo = derin.readObject();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)certInfo);
        return new X509CertificateObject(Certificate.getInstance((Object)seq));
    }

    public byte[] createCertificateRequest(String subject, KeyPair keyPair) throws GeneralSecurityException {
        X509Name name = new X509Name(subject);
        return this.createCertificateRequest(name, "MD5WithRSAEncryption", keyPair);
    }

    public byte[] createCertificateRequest(X509Certificate cert, KeyPair keyPair) throws GeneralSecurityException {
        String issuer = cert.getSubjectDN().getName();
        X509Name subjectDN = new X509Name(issuer + ",CN=proxy");
        String sigAlgName = cert.getSigAlgName();
        return this.createCertificateRequest(subjectDN, sigAlgName, keyPair);
    }

    public byte[] createCertificateRequest(X509Name subjectDN, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        ASN1Set attrs = null;
        PKCS10CertificationRequest certReq = null;
        certReq = new PKCS10CertificationRequest(sigAlgName, subjectDN, keyPair.getPublic(), attrs, keyPair.getPrivate());
        return certReq.getEncoded();
    }

    public static GSIConstants.CertificateType decideProxyType(X509Certificate issuerCert, GSIConstants.DelegationType delegType) throws CertificateException {
        GSIConstants.CertificateType proxyType = GSIConstants.CertificateType.UNDEFINED;
        if (delegType == GSIConstants.DelegationType.LIMITED) {
            GSIConstants.CertificateType type = BouncyCastleUtil.getCertificateType(issuerCert);
            proxyType = ProxyCertificateUtil.isGsi4Proxy(type) ? GSIConstants.CertificateType.GSI_4_LIMITED_PROXY : (ProxyCertificateUtil.isGsi3Proxy(type) ? GSIConstants.CertificateType.GSI_3_LIMITED_PROXY : (ProxyCertificateUtil.isGsi2Proxy(type) ? GSIConstants.CertificateType.GSI_2_LIMITED_PROXY : (VersionUtil.isGsi2Enabled() ? GSIConstants.CertificateType.GSI_2_LIMITED_PROXY : (VersionUtil.isGsi3Enabled() ? GSIConstants.CertificateType.GSI_3_LIMITED_PROXY : GSIConstants.CertificateType.GSI_4_LIMITED_PROXY))));
        } else if (delegType == GSIConstants.DelegationType.FULL) {
            GSIConstants.CertificateType type = BouncyCastleUtil.getCertificateType(issuerCert);
            proxyType = ProxyCertificateUtil.isGsi4Proxy(type) ? GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY : (ProxyCertificateUtil.isGsi3Proxy(type) ? GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY : (ProxyCertificateUtil.isGsi2Proxy(type) ? GSIConstants.CertificateType.GSI_2_PROXY : (VersionUtil.isGsi2Enabled() ? GSIConstants.CertificateType.GSI_2_PROXY : (VersionUtil.isGsi3Enabled() ? GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY : GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY))));
        }
        return proxyType;
    }

    protected X509Certificate[] getX509CertificateObjectChain(X509Certificate[] certs) throws GeneralSecurityException {
        X509Certificate[] bcCerts = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            bcCerts[i] = !(certs[i] instanceof X509CertificateObject) ? CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(certs[i].getEncoded())) : certs[i];
        }
        return bcCerts;
    }
}

