/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.configuration.json;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.json.JsonException;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.configuration.Configurable;
import org.jnosql.artemis.configuration.ConfigurableImpl;
import org.jnosql.artemis.configuration.ConfigurableReader;
import org.jnosql.artemis.configuration.ConfigurationException;

@Named(value="json")
@ApplicationScoped
class ConfigurableReaderJSON
implements ConfigurableReader {
    private static final Jsonb JSONB = JsonbBuilder.create();
    private static final Logger LOGGER = Logger.getLogger(ConfigurableReaderJSON.class.getName());
    private static final Type TYPE = new ArrayList<ConfigurableImpl>(){}.getClass().getGenericSuperclass();
    private final Map<String, List<Configurable>> cache = new ConcurrentHashMap<String, List<Configurable>>();

    ConfigurableReaderJSON() {
    }

    @Override
    public List<Configurable> read(Supplier<InputStream> stream, ConfigurationUnit annotation) {
        List configurations = this.cache.get(annotation.fileName());
        if (Objects.nonNull(configurations)) {
            LOGGER.info("Loading the configuration file from the cache file: " + annotation.fileName());
            return configurations;
        }
        try {
            configurations = (List)JSONB.fromJson(stream.get(), TYPE);
            this.cache.put(annotation.fileName(), configurations);
            return configurations;
        }
        catch (JsonException exception) {
            throw new ConfigurationException("An error when read the JSON file: " + annotation.fileName(), exception);
        }
    }
}

