/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.configuration.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.configuration.Configurable;
import org.jnosql.artemis.configuration.ConfigurableReader;
import org.jnosql.artemis.configuration.ConfigurationException;
import org.jnosql.artemis.configuration.yaml.ConfigurablesYAML;

@Named(value="yaml")
@ApplicationScoped
class ConfigurableReaderYAML
implements ConfigurableReader {
    private static final Logger LOGGER = Logger.getLogger(ConfigurableReaderYAML.class.getName());
    private final Map<String, List<Configurable>> cache = new ConcurrentHashMap<String, List<Configurable>>();
    final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    ConfigurableReaderYAML() {
    }

    @Override
    public List<Configurable> read(Supplier<InputStream> stream, ConfigurationUnit annotation) {
        List<Configurable> configurations = this.cache.get(annotation.fileName());
        if (Objects.nonNull(configurations)) {
            LOGGER.info("Loading the configuration file from the cache file: " + annotation.fileName());
            return configurations;
        }
        try {
            ConfigurablesYAML yaml = (ConfigurablesYAML)this.mapper.readValue(stream.get(), ConfigurablesYAML.class);
            ArrayList<Configurable> configurables = new ArrayList<Configurable>(Optional.ofNullable(yaml.getConfigurations()).orElse(Collections.emptyList()));
            this.cache.put(annotation.fileName(), configurables);
            return configurables;
        }
        catch (IOException exception) {
            throw new ConfigurationException("An error when read the YAML file: " + annotation.fileName(), exception);
        }
    }
}

