
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}KohonenMap" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}NUM-ARRAY" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Partition" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Covariances" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="size" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "kohonenMap",
    "array",
    "partition",
    "covariances"
})
@XmlRootElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_2")
public class Cluster
    extends Entity
    implements HasExtensions, HasId
{

    @XmlAttribute(name = "id")
    @Added(Version.PMML_4_1)
    protected String id;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "size")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    protected Integer size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_2")
    protected KohonenMap kohonenMap;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_2")
    protected Array array;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_2")
    protected Partition partition;
    @XmlElement(name = "Covariances", namespace = "http://www.dmg.org/PMML-4_2")
    protected Covariances covariances;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the size property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSize(Integer value) {
        this.size = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the kohonenMap property.
     * 
     * @return
     *     possible object is
     *     {@link KohonenMap }
     *     
     */
    public KohonenMap getKohonenMap() {
        return kohonenMap;
    }

    /**
     * Sets the value of the kohonenMap property.
     * 
     * @param value
     *     allowed object is
     *     {@link KohonenMap }
     *     
     */
    public void setKohonenMap(KohonenMap value) {
        this.kohonenMap = value;
    }

    /**
     * Gets the value of the array property.
     * 
     * @return
     *     possible object is
     *     {@link Array }
     *     
     */
    public Array getArray() {
        return array;
    }

    /**
     * Sets the value of the array property.
     * 
     * @param value
     *     allowed object is
     *     {@link Array }
     *     
     */
    public void setArray(Array value) {
        this.array = value;
    }

    /**
     * Gets the value of the partition property.
     * 
     * @return
     *     possible object is
     *     {@link Partition }
     *     
     */
    public Partition getPartition() {
        return partition;
    }

    /**
     * Sets the value of the partition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Partition }
     *     
     */
    public void setPartition(Partition value) {
        this.partition = value;
    }

    /**
     * Gets the value of the covariances property.
     * 
     * @return
     *     possible object is
     *     {@link Covariances }
     *     
     */
    public Covariances getCovariances() {
        return covariances;
    }

    /**
     * Sets the value of the covariances property.
     * 
     * @param value
     *     allowed object is
     *     {@link Covariances }
     *     
     */
    public void setCovariances(Covariances value) {
        this.covariances = value;
    }

    public Cluster withId(String value) {
        setId(value);
        return this;
    }

    public Cluster withName(String value) {
        setName(value);
        return this;
    }

    public Cluster withSize(Integer value) {
        setSize(value);
        return this;
    }

    public Cluster withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Cluster withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Cluster withKohonenMap(KohonenMap value) {
        setKohonenMap(value);
        return this;
    }

    public Cluster withArray(Array value) {
        setArray(value);
        return this;
    }

    public Cluster withPartition(Partition value) {
        setPartition(value);
        return this;
    }

    public Cluster withCovariances(Covariances value) {
        setCovariances(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.kohonenMap!= null)) {
            status = this.kohonenMap.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.array!= null)) {
            status = this.array.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.partition!= null)) {
            status = this.partition.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.covariances!= null)) {
            status = this.covariances.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
