
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="minimumNumberOfItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="1" />
 *       &lt;attribute name="maximumNumberOfItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="minimumNumberOfAntecedentItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="1" />
 *       &lt;attribute name="maximumNumberOfAntecedentItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="minimumNumberOfConsequentItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="1" />
 *       &lt;attribute name="maximumNumberOfConsequentItems" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="minimumSupport" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="minimumConfidence" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="minimumLift" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="minimumTotalSequenceTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="maximumTotalSequenceTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="minimumItemsetSeparationTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="maximumItemsetSeparationTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="minimumAntConsSeparationTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="maximumAntConsSeparationTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_3_1)
public class Constraints
    extends PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "minimumNumberOfItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer minimumNumberOfItems;
    @XmlAttribute(name = "maximumNumberOfItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer maximumNumberOfItems;
    @XmlAttribute(name = "minimumNumberOfAntecedentItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer minimumNumberOfAntecedentItems;
    @XmlAttribute(name = "maximumNumberOfAntecedentItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer maximumNumberOfAntecedentItems;
    @XmlAttribute(name = "minimumNumberOfConsequentItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer minimumNumberOfConsequentItems;
    @XmlAttribute(name = "maximumNumberOfConsequentItems")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer maximumNumberOfConsequentItems;
    @XmlAttribute(name = "minimumSupport")
    protected Double minimumSupport;
    @XmlAttribute(name = "minimumConfidence")
    protected Double minimumConfidence;
    @XmlAttribute(name = "minimumLift")
    protected Double minimumLift;
    @XmlAttribute(name = "minimumTotalSequenceTime")
    protected Double minimumTotalSequenceTime;
    @XmlAttribute(name = "maximumTotalSequenceTime")
    protected Double maximumTotalSequenceTime;
    @XmlAttribute(name = "minimumItemsetSeparationTime")
    protected Double minimumItemsetSeparationTime;
    @XmlAttribute(name = "maximumItemsetSeparationTime")
    protected Double maximumItemsetSeparationTime;
    @XmlAttribute(name = "minimumAntConsSeparationTime")
    protected Double minimumAntConsSeparationTime;
    @XmlAttribute(name = "maximumAntConsSeparationTime")
    protected Double maximumAntConsSeparationTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;

    /**
     * Gets the value of the minimumNumberOfItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getMinimumNumberOfItems() {
        if (minimumNumberOfItems == null) {
            return new IntegerAdapter().unmarshal("1");
        } else {
            return minimumNumberOfItems;
        }
    }

    /**
     * Sets the value of the minimumNumberOfItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMinimumNumberOfItems(Integer value) {
        this.minimumNumberOfItems = value;
    }

    /**
     * Gets the value of the maximumNumberOfItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaximumNumberOfItems() {
        return maximumNumberOfItems;
    }

    /**
     * Sets the value of the maximumNumberOfItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMaximumNumberOfItems(Integer value) {
        this.maximumNumberOfItems = value;
    }

    /**
     * Gets the value of the minimumNumberOfAntecedentItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getMinimumNumberOfAntecedentItems() {
        if (minimumNumberOfAntecedentItems == null) {
            return new IntegerAdapter().unmarshal("1");
        } else {
            return minimumNumberOfAntecedentItems;
        }
    }

    /**
     * Sets the value of the minimumNumberOfAntecedentItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMinimumNumberOfAntecedentItems(Integer value) {
        this.minimumNumberOfAntecedentItems = value;
    }

    /**
     * Gets the value of the maximumNumberOfAntecedentItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaximumNumberOfAntecedentItems() {
        return maximumNumberOfAntecedentItems;
    }

    /**
     * Sets the value of the maximumNumberOfAntecedentItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMaximumNumberOfAntecedentItems(Integer value) {
        this.maximumNumberOfAntecedentItems = value;
    }

    /**
     * Gets the value of the minimumNumberOfConsequentItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getMinimumNumberOfConsequentItems() {
        if (minimumNumberOfConsequentItems == null) {
            return new IntegerAdapter().unmarshal("1");
        } else {
            return minimumNumberOfConsequentItems;
        }
    }

    /**
     * Sets the value of the minimumNumberOfConsequentItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMinimumNumberOfConsequentItems(Integer value) {
        this.minimumNumberOfConsequentItems = value;
    }

    /**
     * Gets the value of the maximumNumberOfConsequentItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaximumNumberOfConsequentItems() {
        return maximumNumberOfConsequentItems;
    }

    /**
     * Sets the value of the maximumNumberOfConsequentItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMaximumNumberOfConsequentItems(Integer value) {
        this.maximumNumberOfConsequentItems = value;
    }

    /**
     * Gets the value of the minimumSupport property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumSupport() {
        if (minimumSupport == null) {
            return  0.0D;
        } else {
            return minimumSupport;
        }
    }

    /**
     * Sets the value of the minimumSupport property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumSupport(Double value) {
        this.minimumSupport = value;
    }

    /**
     * Gets the value of the minimumConfidence property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumConfidence() {
        if (minimumConfidence == null) {
            return  0.0D;
        } else {
            return minimumConfidence;
        }
    }

    /**
     * Sets the value of the minimumConfidence property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumConfidence(Double value) {
        this.minimumConfidence = value;
    }

    /**
     * Gets the value of the minimumLift property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumLift() {
        if (minimumLift == null) {
            return  0.0D;
        } else {
            return minimumLift;
        }
    }

    /**
     * Sets the value of the minimumLift property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumLift(Double value) {
        this.minimumLift = value;
    }

    /**
     * Gets the value of the minimumTotalSequenceTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumTotalSequenceTime() {
        if (minimumTotalSequenceTime == null) {
            return  0.0D;
        } else {
            return minimumTotalSequenceTime;
        }
    }

    /**
     * Sets the value of the minimumTotalSequenceTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumTotalSequenceTime(Double value) {
        this.minimumTotalSequenceTime = value;
    }

    /**
     * Gets the value of the maximumTotalSequenceTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMaximumTotalSequenceTime() {
        return maximumTotalSequenceTime;
    }

    /**
     * Sets the value of the maximumTotalSequenceTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMaximumTotalSequenceTime(Double value) {
        this.maximumTotalSequenceTime = value;
    }

    /**
     * Gets the value of the minimumItemsetSeparationTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumItemsetSeparationTime() {
        if (minimumItemsetSeparationTime == null) {
            return  0.0D;
        } else {
            return minimumItemsetSeparationTime;
        }
    }

    /**
     * Sets the value of the minimumItemsetSeparationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumItemsetSeparationTime(Double value) {
        this.minimumItemsetSeparationTime = value;
    }

    /**
     * Gets the value of the maximumItemsetSeparationTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMaximumItemsetSeparationTime() {
        return maximumItemsetSeparationTime;
    }

    /**
     * Sets the value of the maximumItemsetSeparationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMaximumItemsetSeparationTime(Double value) {
        this.maximumItemsetSeparationTime = value;
    }

    /**
     * Gets the value of the minimumAntConsSeparationTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getMinimumAntConsSeparationTime() {
        if (minimumAntConsSeparationTime == null) {
            return  0.0D;
        } else {
            return minimumAntConsSeparationTime;
        }
    }

    /**
     * Sets the value of the minimumAntConsSeparationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimumAntConsSeparationTime(Double value) {
        this.minimumAntConsSeparationTime = value;
    }

    /**
     * Gets the value of the maximumAntConsSeparationTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMaximumAntConsSeparationTime() {
        return maximumAntConsSeparationTime;
    }

    /**
     * Sets the value of the maximumAntConsSeparationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMaximumAntConsSeparationTime(Double value) {
        this.maximumAntConsSeparationTime = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Constraints withMinimumNumberOfItems(Integer value) {
        setMinimumNumberOfItems(value);
        return this;
    }

    public Constraints withMaximumNumberOfItems(Integer value) {
        setMaximumNumberOfItems(value);
        return this;
    }

    public Constraints withMinimumNumberOfAntecedentItems(Integer value) {
        setMinimumNumberOfAntecedentItems(value);
        return this;
    }

    public Constraints withMaximumNumberOfAntecedentItems(Integer value) {
        setMaximumNumberOfAntecedentItems(value);
        return this;
    }

    public Constraints withMinimumNumberOfConsequentItems(Integer value) {
        setMinimumNumberOfConsequentItems(value);
        return this;
    }

    public Constraints withMaximumNumberOfConsequentItems(Integer value) {
        setMaximumNumberOfConsequentItems(value);
        return this;
    }

    public Constraints withMinimumSupport(Double value) {
        setMinimumSupport(value);
        return this;
    }

    public Constraints withMinimumConfidence(Double value) {
        setMinimumConfidence(value);
        return this;
    }

    public Constraints withMinimumLift(Double value) {
        setMinimumLift(value);
        return this;
    }

    public Constraints withMinimumTotalSequenceTime(Double value) {
        setMinimumTotalSequenceTime(value);
        return this;
    }

    public Constraints withMaximumTotalSequenceTime(Double value) {
        setMaximumTotalSequenceTime(value);
        return this;
    }

    public Constraints withMinimumItemsetSeparationTime(Double value) {
        setMinimumItemsetSeparationTime(value);
        return this;
    }

    public Constraints withMaximumItemsetSeparationTime(Double value) {
        setMaximumItemsetSeparationTime(value);
        return this;
    }

    public Constraints withMinimumAntConsSeparationTime(Double value) {
        setMinimumAntConsSeparationTime(value);
        return this;
    }

    public Constraints withMaximumAntConsSeparationTime(Double value) {
        setMaximumAntConsSeparationTime(value);
        return this;
    }

    public Constraints withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Constraints withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
