
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "mean",
    "variance",
    "extensions"
})
public class GaussianDistribution
    extends ContinuousDistribution
    implements HasExtensions<GaussianDistribution>
{

    @XmlAttribute(name = "mean", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "variance", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("variance")
    private Number variance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305489L;

    public GaussianDistribution() {
    }

    public GaussianDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Number mean,
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public Number getMean() {
        return mean;
    }

    public GaussianDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number getVariance() {
        return variance;
    }

    public GaussianDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GaussianDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
