
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution"
})
@XmlRootElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "continuousDistribution"
})
public class Alternate
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Alternate>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.UniformDistribution.class)
    })
    @JsonProperty("ContinuousDistribution")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AnyDistribution", value = org.dmg.pmml.AnyDistribution.class),
        @JsonSubTypes.Type(name = "GaussianDistribution", value = org.dmg.pmml.GaussianDistribution.class),
        @JsonSubTypes.Type(name = "PoissonDistribution", value = org.dmg.pmml.PoissonDistribution.class),
        @JsonSubTypes.Type(name = "UniformDistribution", value = org.dmg.pmml.UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;
    private final static long serialVersionUID = 67305489L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Alternate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    public Alternate setContinuousDistribution(
        @Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
