
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Optional;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "embeddedModels",
    "segmentation",
    "modelVerification"
})
@XmlRootElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "embeddedModels",
    "segmentation",
    "modelVerification"
})
public class MiningModel
    extends Model
    implements HasExtensions<MiningModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.regression.Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.tree.DecisionTree.class)
    })
    @Deprecated((org.dmg.pmml.Version.PMML_4_1))
    @Optional((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("EmbeddedModel")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Regression", value = org.dmg.pmml.regression.Regression.class),
        @JsonSubTypes.Type(name = "DecisionTree", value = org.dmg.pmml.tree.DecisionTree.class)
    })
    private List<EmbeddedModel> embeddedModels;
    @XmlElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Segmentation")
    private Segmentation segmentation;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305489L;

    public MiningModel() {
    }

    public MiningModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
    }

    public String getModelName() {
        return modelName;
    }

    public MiningModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public MiningModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public MiningModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public MiningModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public MiningModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public MiningModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public MiningModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public MiningModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public MiningModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public MiningModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public MiningModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasEmbeddedModels() {
        return ((this.embeddedModels!= null)&&(this.embeddedModels.size()> 0));
    }

    public List<EmbeddedModel> getEmbeddedModels() {
        if (embeddedModels == null) {
            embeddedModels = new ArrayList<EmbeddedModel>();
        }
        return this.embeddedModels;
    }

    public MiningModel addEmbeddedModels(EmbeddedModel... embeddedModels) {
        getEmbeddedModels().addAll(Arrays.asList(embeddedModels));
        return this;
    }

    public Segmentation getSegmentation() {
        return segmentation;
    }

    public MiningModel setSegmentation(
        @org.jpmml.model.annotations.Property("segmentation")
        Segmentation segmentation) {
        this.segmentation = segmentation;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public MiningModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasEmbeddedModels()) {
                status = PMMLObject.traverse(visitor, getEmbeddedModels());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getSegmentation(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
