/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.IOUtils;
import java.io.Writer;
import javaemul.internal.InternalPreconditions;

public class BufferedWriter
extends Writer {
    private static int defaultCharBufferSize = 8192;
    private Writer out;
    private char[] buf;
    private int pos;
    private int size;

    public BufferedWriter(Writer out) {
        this(out, defaultCharBufferSize);
    }

    public BufferedWriter(Writer out, int size) {
        super(out);
        InternalPreconditions.checkArgument(size > 0, "Buffer size <= 0");
        this.out = out;
        this.buf = new char[size];
        this.size = size;
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        try (Writer w = this.out;){
            this.flushBuffer();
        }
        finally {
            this.out = null;
            this.buf = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void ensureOpen() throws IOException {
        InternalPreconditions.checkState(this.out != null, "stream closed");
    }

    private void flushBuffer() throws IOException {
        this.ensureOpen();
        if (this.pos > 0) {
            this.out.write(this.buf, 0, this.pos);
        }
        this.pos = 0;
    }

    public void newLine() throws IOException {
        this.write("\n");
    }

    @Override
    public void write(char[] buffer, int offset, int count) throws IOException {
        this.ensureOpen();
        IOUtils.checkOffsetAndCount(buffer, offset, count);
        if (count >= this.size) {
            this.flushBuffer();
            this.out.write(buffer, offset, count);
            return;
        }
        int b = offset;
        int t = offset + count;
        while (b < t) {
            int d = Math.min(this.size - this.pos, t - b);
            System.arraycopy(buffer, b, this.buf, this.pos, d);
            b += d;
            this.pos += d;
            if (this.pos < this.size) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void write(int oneChar) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.size) {
            this.out.write(this.buf, 0, this.buf.length);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)oneChar;
    }

    @Override
    public void write(String str, int offset, int count) throws IOException {
        this.ensureOpen();
        InternalPreconditions.checkNotNull(str);
        int b = offset;
        int t = offset + count;
        while (b < t) {
            int d = Math.min(this.size - this.pos, t - b);
            str.getChars(b, b + d, this.buf, this.pos);
            b += d;
            this.pos += d;
            if (this.pos < this.size) continue;
            this.flushBuffer();
        }
    }
}

