/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.IOUtils;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] buf) {
        this.mark = 0;
        this.buf = buf;
        this.count = buf.length;
    }

    public ByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.mark = offset;
        this.count = offset + length > buf.length ? buf.length : offset + length;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) {
        IOUtils.checkOffsetAndCount(buffer, byteOffset, byteCount);
        if (this.pos >= this.count) {
            return -1;
        }
        if (byteCount == 0) {
            return 0;
        }
        int copylen = this.count - this.pos < byteCount ? this.count - this.pos : byteCount;
        System.arraycopy(this.buf, this.pos, buffer, byteOffset, copylen);
        this.pos += copylen;
        return copylen;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public long skip(long byteCount) {
        if (byteCount <= 0L) {
            return 0L;
        }
        int temp = this.pos;
        this.pos = (long)(this.count - this.pos) < byteCount ? this.count : (int)((long)this.pos + byteCount);
        return this.pos - temp;
    }
}

