/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.IOUtils;
import javaemul.internal.InternalPreconditions;

public abstract class InputStream
implements Closeable {
    private static final int MAX_SKIP_BUFFER_SIZE = 4096;

    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] buffer) throws IOException {
        InternalPreconditions.checkNotNull(buffer);
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        IOUtils.checkOffsetAndCount(buffer, byteOffset, byteCount);
        for (int i = 0; i < byteCount; ++i) {
            int c;
            try {
                c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
            }
            catch (IOException e) {
                if (i != 0) {
                    return i;
                }
                throw e;
            }
            buffer[byteOffset + i] = (byte)c;
        }
        return byteCount;
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long byteCount) throws IOException {
        int toRead;
        long skipped;
        int readCount;
        if (byteCount <= 0L) {
            return 0L;
        }
        int bSize = (int)Math.min(4096L, byteCount);
        byte[] b = new byte[bSize];
        for (skipped = 0L; skipped < byteCount && (readCount = this.read(b, 0, toRead = (int)Math.min(byteCount - skipped, (long)b.length))) != -1; skipped += (long)readCount) {
            if (readCount >= toRead) continue;
            break;
        }
        return skipped;
    }
}

