/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.IOUtils;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javaemul.internal.EmulatedCharset;
import javaemul.internal.InternalPreconditions;

public class OutputStreamWriter
extends Writer {
    private final OutputStream out;
    private final Charset charset;
    private final char[] surrogateBuffer = new char[2];

    public OutputStreamWriter(OutputStream out, String charsetName) {
        this(out, Charset.forName(charsetName));
    }

    public OutputStreamWriter(OutputStream out, Charset charset) {
        this.out = InternalPreconditions.checkNotNull(out);
        this.charset = InternalPreconditions.checkNotNull(charset);
    }

    @Override
    public void close() throws IOException {
        if (this.surrogateBuffer[0] != '\u0000') {
            this.out.write(63);
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public String getEncoding() {
        return this.charset.name();
    }

    @Override
    public void write(char[] buffer, int offset, int count) throws IOException {
        IOUtils.checkOffsetAndCount(buffer, offset, count);
        if (count == 0) {
            return;
        }
        if (this.surrogateBuffer[0] != '\u0000') {
            this.surrogateBuffer[1] = buffer[offset++];
            --count;
            this.out.write(((EmulatedCharset)this.charset).getBytes(this.surrogateBuffer, 0, 2));
            this.surrogateBuffer[0] = '\u0000';
        }
        if (count > 0 && Character.isHighSurrogate(buffer[count - 1])) {
            this.surrogateBuffer[0] = buffer[--count];
        }
        byte[] bytes = ((EmulatedCharset)this.charset).getBytes(buffer, offset, count);
        this.out.write(bytes, 0, bytes.length);
    }
}

