/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.IOUtils;
import java.io.OutputStream;

public class PrintStream
extends FilterOutputStream {
    private boolean ioError = false;

    public PrintStream(OutputStream out) {
        super(out);
    }

    public void print(boolean x) {
        this.print(String.valueOf(x));
    }

    public void print(char x) {
        this.print(String.valueOf(x));
    }

    public void print(char[] x) {
        this.print(new String(x, 0, x.length));
    }

    public void print(double x) {
        this.print(String.valueOf(x));
    }

    public void print(float x) {
        this.print(String.valueOf(x));
    }

    public void print(int x) {
        this.print(String.valueOf(x));
    }

    public void print(long x) {
        this.print(String.valueOf(x));
    }

    public void print(Object x) {
        this.print(String.valueOf(x));
    }

    public void print(String s) {
        if (this.out == null) {
            this.setError();
            return;
        }
        if (s == null) {
            this.print("null");
            return;
        }
        try {
            this.write(s.getBytes());
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void println() {
        this.newline();
    }

    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    public void println(char x) {
        this.println(String.valueOf(x));
    }

    public void println(char[] x) {
        this.println(new String(x, 0, x.length));
    }

    public void println(double x) {
        this.println(String.valueOf(x));
    }

    public void println(float x) {
        this.println(String.valueOf(x));
    }

    public void println(int x) {
        this.println(String.valueOf(x));
    }

    public void println(long x) {
        this.println(String.valueOf(x));
    }

    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    public void println(String s) {
        this.print(s);
        this.newline();
    }

    @Override
    public void flush() {
        if (this.out != null) {
            try {
                this.out.flush();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setError();
    }

    @Override
    public void close() {
        this.flush();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                this.setError();
            }
            finally {
                this.out = null;
            }
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        IOUtils.checkOffsetAndCount(buffer, offset, length);
        if (this.out == null) {
            this.setError();
            return;
        }
        try {
            this.out.write(buffer, offset, length);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public void write(int oneByte) {
        if (this.out == null) {
            this.setError();
            return;
        }
        try {
            boolean isNewline;
            this.out.write(oneByte);
            int b = oneByte & 0xFF;
            boolean bl = isNewline = b == 10 || b == 21;
            if (isNewline) {
                this.flush();
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public boolean checkError() {
        this.flush();
        return this.ioError;
    }

    protected void setError() {
        this.ioError = true;
    }

    protected void clearError() {
        this.ioError = false;
    }

    private void newline() {
        this.print('\n');
    }
}

