/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.annotations.HasNoSideEffects;

public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final int SIZE = 8;
    public static final int BYTES = 1;
    public static final Class<Byte> TYPE;
    private final byte value;

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static Byte decode(String s) throws NumberFormatException {
        return (byte)Byte.__decodeAndValidateInt(s, -128, 127);
    }

    public static int hashCode(byte b) {
        return b;
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return Byte.parseByte(s, 10);
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        return (byte)Byte.__parseAndValidateInt(s, radix, -128, 127);
    }

    public static String toString(byte b) {
        return String.valueOf(b);
    }

    public static Byte valueOf(byte b) {
        return BoxedValues.get(b);
    }

    public static Byte valueOf(String s) throws NumberFormatException {
        return Byte.valueOf(s, 10);
    }

    public static Byte valueOf(String s, int radix) throws NumberFormatException {
        return Byte.parseByte(s, radix);
    }

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) {
        this.value = Byte.parseByte(s);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public int compareTo(Byte b) {
        return Byte.compare(this.value, b.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Byte && ((Byte)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    private static class BoxedValues {
        private static final Byte[] boxedValues;

        private BoxedValues() {
        }

        @HasNoSideEffects
        private static Byte get(byte b) {
            return boxedValues[b + 128];
        }

        static {
            Byte[] values = new Byte[256];
            for (int i = 0; i < 256; ++i) {
                values[i] = new Byte((byte)(i - 128));
            }
            boxedValues = values;
        }
    }
}

