/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.NativeRegExp;
import javaemul.internal.StringUtil;
import javaemul.internal.annotations.HasNoSideEffects;

public final class Character
implements Comparable<Character>,
Serializable {
    public static final Class<Character> TYPE;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static NativeRegExp digitRegex;
    private static NativeRegExp leterRegex;
    private static NativeRegExp isLeterOrDigitRegex;
    private final char value;

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static int codePointAt(char[] a, int index) {
        return Character.codePointAt(new CharSequenceAdapter(a), index, a.length);
    }

    public static int codePointAt(char[] a, int index, int limit) {
        return Character.codePointAt(new CharSequenceAdapter(a), index, limit);
    }

    public static int codePointAt(CharSequence seq, int index) {
        return Character.codePointAt(seq, index, seq.length());
    }

    public static int codePointBefore(char[] a, int index) {
        return Character.codePointBefore(new CharSequenceAdapter(a), index, 0);
    }

    public static int codePointBefore(char[] a, int index, int start) {
        return Character.codePointBefore(new CharSequenceAdapter(a), index, start);
    }

    public static int codePointBefore(CharSequence cs, int index) {
        return Character.codePointBefore(cs, index, 0);
    }

    public static int codePointCount(char[] a, int offset, int count) {
        return Character.codePointCount(new CharSequenceAdapter(a), offset, offset + count);
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        int count = 0;
        int idx = beginIndex;
        while (idx < endIndex) {
            char ch;
            if (Character.isHighSurrogate(ch = seq.charAt(idx++)) && idx < endIndex && Character.isLowSurrogate(seq.charAt(idx))) {
                ++idx;
            }
            ++count;
        }
        return count;
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static int digit(char c, int radix) {
        if (radix < 2 || radix > 36) {
            return -1;
        }
        if (c >= '0' && c < 48 + Math.min(radix, 10)) {
            return c - 48;
        }
        if (c >= 'a' && c < radix + 97 - 10) {
            return c - 97 + 10;
        }
        if (c >= 'A' && c < radix + 65 - 10) {
            return c - 65 + 10;
        }
        return -1;
    }

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36) {
            return '\u0000';
        }
        if (digit < 0 || digit >= radix) {
            return '\u0000';
        }
        return Character.forDigit(digit);
    }

    public static int hashCode(char c) {
        return c;
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 65535;
    }

    public static boolean isDigit(char c) {
        if (digitRegex == null) {
            digitRegex = new NativeRegExp("\\d");
        }
        return digitRegex.test(String.valueOf(c));
    }

    public static boolean isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    public static boolean isLetter(char c) {
        if (leterRegex == null) {
            leterRegex = new NativeRegExp("[A-Z]", "i");
        }
        return leterRegex.test(String.valueOf(c));
    }

    public static boolean isLetterOrDigit(char c) {
        if (isLeterOrDigitRegex == null) {
            isLeterOrDigitRegex = new NativeRegExp("[A-Z\\d]", "i");
        }
        return isLeterOrDigitRegex.test(String.valueOf(c));
    }

    public static boolean isLowerCase(char c) {
        return Character.toLowerCase(c) == c && Character.isLetter(c);
    }

    public static boolean isLowSurrogate(char ch) {
        return ch >= '\udc00' && ch <= '\udfff';
    }

    public static boolean isSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udfff';
    }

    @Deprecated
    public static boolean isSpace(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\t': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\r': {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char ch) {
        return StringUtil.isWhitespace(String.valueOf(ch));
    }

    public static boolean isWhitespace(int codePoint) {
        return Character.isValidCodePoint(codePoint) && StringUtil.isWhitespace(String.fromCodePoint(codePoint));
    }

    public static boolean isSpaceChar(char ch) {
        return StringUtil.isSpace(String.valueOf(ch));
    }

    public static boolean isSpaceChar(int codePoint) {
        return Character.isValidCodePoint(codePoint) && StringUtil.isSpace(String.fromCodePoint(codePoint));
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static boolean isSurrogatePair(char highSurrogate, char lowSurrogate) {
        return Character.isHighSurrogate(highSurrogate) && Character.isLowSurrogate(lowSurrogate);
    }

    public static boolean isTitleCase(char c) {
        return c != Character.toUpperCase(c) && c != Character.toLowerCase(c);
    }

    public static char toTitleCase(char c) {
        if (c >= '\u01c4' && c <= '\u01cc' || c >= '\u01f1' && c <= '\u01f3') {
            return (char)((c + '\u0001') / 3 * 3);
        }
        if (c >= '\u10d0' && c <= '\u10fa' || c >= '\u10fd' && c <= '\u10ff') {
            return c;
        }
        return Character.toUpperCase(c);
    }

    public static boolean isUpperCase(char c) {
        return Character.toUpperCase(c) == c && Character.isLetter(c);
    }

    public static boolean isValidCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 0x10FFFF;
    }

    public static int offsetByCodePoints(char[] a, int start, int count, int index, int codePointOffset) {
        return Character.offsetByCodePoints(new CharSequenceAdapter(a, start, count), index, codePointOffset);
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        if (codePointOffset < 0) {
            while (codePointOffset < 0) {
                if (Character.isLowSurrogate(seq.charAt(--index)) && Character.isHighSurrogate(seq.charAt(index - 1))) {
                    --index;
                }
                ++codePointOffset;
            }
        } else {
            while (codePointOffset > 0) {
                if (Character.isHighSurrogate(seq.charAt(index)) && Character.isLowSurrogate(seq.charAt(index + 1))) {
                    ++index;
                }
                ++index;
                --codePointOffset;
            }
        }
        return index;
    }

    public static char[] toChars(int codePoint) {
        InternalPreconditions.checkArgument(Character.isValidCodePoint(codePoint));
        if (codePoint >= 65536) {
            return new char[]{Character.highSurrogate(codePoint), Character.lowSurrogate(codePoint)};
        }
        return new char[]{(char)codePoint};
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        InternalPreconditions.checkArgument(Character.isValidCodePoint(codePoint));
        if (codePoint >= 65536) {
            dst[dstIndex++] = Character.highSurrogate(codePoint);
            dst[dstIndex] = Character.lowSurrogate(codePoint);
            return 2;
        }
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static int toCodePoint(char highSurrogate, char lowSurrogate) {
        return 65536 + ((highSurrogate & 0x3FF) << 10) + (lowSurrogate & 0x3FF);
    }

    public static int toLowerCase(int c) {
        return CaseMapper.codePointToLowerCase(c);
    }

    public static int toUpperCase(int c) {
        return CaseMapper.codePointToUpperCase(c);
    }

    public static char toLowerCase(char c) {
        return CaseMapper.charToLowerCase(c);
    }

    public static char toUpperCase(char c) {
        return CaseMapper.charToUpperCase(c);
    }

    public static String toString(char x) {
        return String.valueOf(x);
    }

    public static String toString(int x) {
        return String.fromCodePoint(x);
    }

    public static Character valueOf(char c) {
        if (c < '\u0080') {
            return BoxedValues.get(c);
        }
        return new Character(c);
    }

    static int codePointAt(CharSequence cs, int index, int limit) {
        char loSurrogate;
        char hiSurrogate;
        if (Character.isHighSurrogate(hiSurrogate = cs.charAt(index++)) && index < limit && Character.isLowSurrogate(loSurrogate = cs.charAt(index))) {
            return Character.toCodePoint(hiSurrogate, loSurrogate);
        }
        return hiSurrogate;
    }

    static int codePointBefore(CharSequence cs, int index, int start) {
        char highSurrogate;
        char loSurrogate;
        if (Character.isLowSurrogate(loSurrogate = cs.charAt(--index)) && index > start && Character.isHighSurrogate(highSurrogate = cs.charAt(index - 1))) {
            return Character.toCodePoint(highSurrogate, loSurrogate);
        }
        return loSurrogate;
    }

    static char forDigit(int digit) {
        int overBaseTen = digit - 10;
        return (char)(overBaseTen < 0 ? 48 + digit : 97 + overBaseTen);
    }

    public static char highSurrogate(int codePoint) {
        return (char)(55296 + (codePoint - 65536 >> 10 & 0x3FF));
    }

    public static char lowSurrogate(int codePoint) {
        return (char)(56320 + (codePoint - 65536 & 0x3FF));
    }

    public Character(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    @Override
    public int compareTo(Character c) {
        return Character.compare(this.value, c.value);
    }

    public boolean equals(Object o) {
        return o instanceof Character && ((Character)o).value == this.value;
    }

    public int hashCode() {
        return Character.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    private static class BoxedValues {
        private static final Character[] boxedValues;

        private BoxedValues() {
        }

        @HasNoSideEffects
        private static Character get(char c) {
            return boxedValues[c];
        }

        static {
            Character[] values = new Character[128];
            for (char i = '\u0000'; i < '\u0080'; i = (char)(i + '\u0001')) {
                values[i] = new Character(i);
            }
            boxedValues = values;
        }
    }

    static class CharSequenceAdapter
    implements CharSequence {
        private char[] charArray;
        private int start;
        private int end;

        public CharSequenceAdapter(char[] charArray) {
            this(charArray, 0, charArray.length);
        }

        public CharSequenceAdapter(char[] charArray, int start, int end) {
            this.charArray = charArray;
            this.start = start;
            this.end = end;
        }

        @Override
        public char charAt(int index) {
            return this.charArray[index + this.start];
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharSequenceAdapter(this.charArray, this.start + start, this.start + end);
        }
    }
}

