/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.Platform;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE;
    private static final long POWER_31_INT = 0x80000000L;
    private final float value;

    public static int compare(float x, float y) {
        return Double.compare(x, y);
    }

    public static int floatToIntBits(float value) {
        if (Float.isNaN(value)) {
            return 2143289344;
        }
        return Float.floatToRawIntBits(value);
    }

    private static int floatToRawIntBits(float value) {
        return Platform.floatToRawIntBits(value);
    }

    public static int hashCode(float f) {
        return Platform.hashCode(f);
    }

    public static float intBitsToFloat(int bits) {
        return Platform.intBitsToFloat(bits);
    }

    public static boolean isFinite(float x) {
        return Double.isFinite(x);
    }

    public static boolean isInfinite(float x) {
        return Double.isInfinite(x);
    }

    public static boolean isNaN(float x) {
        return Double.isNaN(x);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static float parseFloat(String s) throws NumberFormatException {
        double doubleValue = Float.__parseAndValidateDouble(s);
        if (doubleValue > 3.4028234663852886E38) {
            return Float.POSITIVE_INFINITY;
        }
        if (doubleValue < -3.4028234663852886E38) {
            return Float.NEGATIVE_INFINITY;
        }
        return (float)doubleValue;
    }

    public static float sum(float a, float b) {
        return a + b;
    }

    public static String toString(float f) {
        return RealToString.floatToString(f);
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static Float valueOf(String s) throws NumberFormatException {
        return new Float(s);
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(String s) {
        this.value = Float.parseFloat(s);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Float b) {
        return Float.compare(this.value, b.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return Platform.isEqual(this, o);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    static Double toDouble(Float f) {
        return f == null ? null : Double.valueOf(f.doubleValue());
    }
}

