/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import javaemul.internal.JsUtils;
import javaemul.internal.NativeRegExp;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

public abstract class Number
implements Serializable {
    private static NativeRegExp floatRegex;

    static boolean $isInstance(Object instance) {
        return "number".equals(JsUtils.typeOf(instance)) || instance instanceof JavaLangNumber;
    }

    protected static int __decodeAndValidateInt(String s, int lowerBound, int upperBound) throws NumberFormatException {
        __Decode decode = Number.__decodeNumberString(s);
        return Number.__parseAndValidateInt(decode.payload, decode.radix, lowerBound, upperBound);
    }

    protected static __Decode __decodeNumberString(String s) {
        int radix;
        boolean negative;
        if (s.startsWith("-")) {
            negative = true;
            s = s.substring(1);
        } else {
            negative = false;
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
        }
        if (s.startsWith("0x") || s.startsWith("0X")) {
            s = s.substring(2);
            radix = 16;
        } else if (s.startsWith("#")) {
            s = s.substring(1);
            radix = 16;
        } else {
            radix = s.startsWith("0") ? 8 : 10;
        }
        if (negative) {
            s = "-" + s;
        }
        return new __Decode(radix, s);
    }

    protected static double __parseAndValidateDouble(String s) throws NumberFormatException {
        if (!Number.__isValidDouble(s)) {
            throw NumberFormatException.forInputString(s);
        }
        return Number.parseFloat(s);
    }

    @JsMethod(namespace="<global>")
    private static native double parseFloat(String var0);

    protected static int __parseAndValidateInt(String s, int radix, int lowerBound, int upperBound) throws NumberFormatException {
        boolean isTooLow;
        int startIndex;
        int length;
        if (s == null) {
            throw NumberFormatException.forNullInputString();
        }
        if (radix < 2 || radix > 36) {
            throw NumberFormatException.forRadix(radix);
        }
        for (int i = startIndex = (length = s.length()) > 0 && (s.charAt(0) == '-' || s.charAt(0) == '+') ? 1 : 0; i < length; ++i) {
            if (Character.digit(s.charAt(i), radix) != -1) continue;
            throw NumberFormatException.forInputString(s);
        }
        int toReturn = Number.parseInt(s, radix);
        boolean bl = isTooLow = toReturn < lowerBound;
        if (Double.isNaN(toReturn)) {
            throw NumberFormatException.forInputString(s);
        }
        if (isTooLow || toReturn > upperBound) {
            throw NumberFormatException.forInputString(s);
        }
        return toReturn;
    }

    protected static long __parseAndValidateLong(String s, int radix) throws NumberFormatException {
        char c;
        if (s == null) {
            throw NumberFormatException.forNullInputString();
        }
        if (radix < 2 || radix > 36) {
            throw NumberFormatException.forRadix(radix);
        }
        String orig = s;
        int length = s.length();
        boolean negative = false;
        if (length > 0 && ((c = s.charAt(0)) == '-' || c == '+')) {
            s = s.substring(1);
            --length;
            boolean bl = negative = c == '-';
        }
        if (length == 0) {
            throw NumberFormatException.forInputString(orig);
        }
        while (s.length() > 0 && s.charAt(0) == '0') {
            s = s.substring(1);
            --length;
        }
        if (length > __ParseLong.maxLengthForRadix[radix]) {
            throw NumberFormatException.forInputString(orig);
        }
        for (int i = 0; i < length; ++i) {
            if (Character.digit(s.charAt(i), radix) != -1) continue;
            throw NumberFormatException.forInputString(orig);
        }
        long toReturn = 0L;
        int maxDigits = __ParseLong.maxDigitsForRadix[radix];
        long radixPower = __ParseLong.maxDigitsRadixPower[radix];
        long minValue = -__ParseLong.maxValueForRadix[radix];
        boolean firstTime = true;
        int head = length % maxDigits;
        if (head > 0) {
            toReturn = -Number.parseInt(s.substring(0, head), radix);
            s = s.substring(head);
            length -= head;
            firstTime = false;
        }
        while (length >= maxDigits) {
            head = Number.parseInt(s.substring(0, maxDigits), radix);
            s = s.substring(maxDigits);
            length -= maxDigits;
            if (!firstTime) {
                if (toReturn < minValue) {
                    throw NumberFormatException.forInputString(orig);
                }
                toReturn *= radixPower;
            } else {
                firstTime = false;
            }
            toReturn -= (long)head;
        }
        if (toReturn > 0L) {
            throw NumberFormatException.forInputString(orig);
        }
        if (!negative && (toReturn = -toReturn) < 0L) {
            throw NumberFormatException.forInputString(orig);
        }
        return toReturn;
    }

    private static boolean __isValidDouble(String str) {
        if (floatRegex == null) {
            floatRegex = new NativeRegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$");
        }
        return floatRegex.test(str);
    }

    @JsMethod(namespace="<global>")
    private static native int parseInt(String var0, int var1);

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public abstract double doubleValue();

    public abstract float floatValue();

    public abstract int intValue();

    public abstract long longValue();

    public short shortValue() {
        return (short)this.intValue();
    }

    @JsType(isNative=true, name="Number$impl", namespace="java.lang")
    private static class JavaLangNumber {
        private JavaLangNumber() {
        }
    }

    static class __ParseLong {
        private static final int[] maxDigitsForRadix = new int[]{-1, -1, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        private static final int[] maxDigitsRadixPower = new int[37];
        private static final int[] maxLengthForRadix = new int[]{-1, -1, 63, 40, 32, 28, 25, 23, 21, 20, 19, 19, 18, 18, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13};
        private static final long[] maxValueForRadix = new long[37];

        __ParseLong() {
        }

        static {
            for (int i = 2; i <= 36; ++i) {
                __ParseLong.maxDigitsRadixPower[i] = (int)Math.pow(i, maxDigitsForRadix[i]);
                __ParseLong.maxValueForRadix[i] = Long.MAX_VALUE / (long)maxDigitsRadixPower[i];
            }
        }
    }

    static class __Decode {
        public final String payload;
        public final int radix;

        public __Decode(int radix, String payload) {
            this.radix = radix;
            this.payload = payload;
        }
    }
}

