/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.annotations.HasNoSideEffects;

public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    public static final Class<Short> TYPE;
    private final short value;

    public static int compare(short x, short y) {
        return x - y;
    }

    public static Short decode(String s) throws NumberFormatException {
        return (short)Short.__decodeAndValidateInt(s, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static int hashCode(short s) {
        return s;
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        return (short)Short.__parseAndValidateInt(s, radix, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short reverseBytes(short s) {
        return (short)((s & 0xFF) << 8 | (s & 0xFF00) >> 8);
    }

    public static String toString(short b) {
        return String.valueOf(b);
    }

    public static Short valueOf(short s) {
        if (s > -129 && s < 128) {
            return BoxedValues.get(s);
        }
        return new Short(s);
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return Short.valueOf(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return Short.parseShort(s, radix);
    }

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) {
        this.value = Short.parseShort(s);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Short b) {
        return Short.compare(this.value, b.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Short && ((Short)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    private static class BoxedValues {
        private static final Short[] boxedValues;

        private BoxedValues() {
        }

        @HasNoSideEffects
        private static Short get(short s) {
            return boxedValues[s + 128];
        }

        static {
            Short[] values = new Short[256];
            for (int i = 0; i < 256; ++i) {
                values[i] = new Short((short)(i - 128));
            }
            boxedValues = values;
        }
    }
}

