/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringJoiner;
import javaemul.internal.ArrayHelper;
import javaemul.internal.EmulatedCharset;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.JsUtils;
import javaemul.internal.NativeRegExp;
import javaemul.internal.StringUtil;
import jsinterop.annotations.JsNonNull;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public final class String
implements Comparable<String>,
CharSequence,
Serializable {
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareToIgnoreCase(b);
        }
    };
    private final String value;

    public static String copyValueOf(char[] v) {
        return String.valueOf(v);
    }

    public static String copyValueOf(char[] v, int offset, int count) {
        return String.valueOf(v, offset, count);
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence e : elements) {
            joiner.add(e);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public static String valueOf(boolean x) {
        return "" + x;
    }

    public static String valueOf(char x) {
        return NativeString.fromCharCode(x);
    }

    public static String valueOf(char[] x, int offset, int count) {
        int end = offset + count;
        InternalPreconditions.checkCriticalStringBounds(offset, end, x.length);
        int batchSize = 10000;
        String s = "";
        int batchStart = offset;
        while (batchStart < end) {
            int batchEnd = Math.min(batchStart + batchSize, end);
            s = s + String.fromCharCode(ArrayHelper.unsafeClone(x, batchStart, batchEnd));
            batchStart = batchEnd;
        }
        return s;
    }

    private static String fromCharCode(Object[] array) {
        return String.getFromCharCodeFunction().apply(null, array);
    }

    @JsProperty(name="String.fromCharCode", namespace="<global>")
    private static native NativeFunction getFromCharCodeFunction();

    public static String valueOf(char[] x) {
        return String.valueOf(x, 0, x.length);
    }

    public static String valueOf(double x) {
        return "" + x;
    }

    public static String valueOf(float x) {
        return "" + x;
    }

    public static String valueOf(int x) {
        return "" + x;
    }

    public static String valueOf(long x) {
        return "" + x;
    }

    public static @JsNonNull String valueOf(Object x) {
        return x == null ? "null" : x.toString();
    }

    private static Charset getCharset(String charsetName) throws UnsupportedEncodingException {
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(charsetName);
        }
    }

    static String fromCodePoint(int codePoint) {
        return NativeString.fromCodePoint(codePoint);
    }

    public String() {
        this.value = "";
    }

    public String(byte[] bytes) {
        this.value = String.createImpl(bytes, EmulatedCharset.UTF_8);
    }

    public String(byte[] bytes, int ofs, int len) {
        this.value = String.createImpl(bytes, ofs, len, EmulatedCharset.UTF_8);
    }

    public String(byte[] bytes, int ofs, int len, String charsetName) throws UnsupportedEncodingException {
        this.value = String.createImpl(bytes, ofs, len, String.getCharset(charsetName));
    }

    public String(byte[] bytes, int ofs, int len, Charset charset) {
        this.value = String.createImpl(bytes, ofs, len, charset);
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this.value = String.createImpl(bytes, String.getCharset(charsetName));
    }

    public String(byte[] bytes, Charset charset) {
        this.value = String.createImpl(bytes, charset);
    }

    public String(char[] value) {
        this.value = String.valueOf(value);
    }

    public String(char[] value, int offset, int count) {
        this.value = String.valueOf(value, offset, count);
    }

    public String(int[] codePoints, int offset, int count) {
        this.value = String.createImpl(codePoints, offset, count);
    }

    private static String createImpl(byte[] bytes, Charset charset) {
        return String.createImpl(bytes, 0, bytes.length, charset);
    }

    private static String createImpl(byte[] bytes, int ofs, int len, Charset charset) {
        InternalPreconditions.checkPositionIndexes(ofs, ofs + len, bytes.length);
        return String.valueOf(((EmulatedCharset)charset).decodeString(bytes, ofs, len));
    }

    private static String createImpl(int[] codePoints, int offset, int count) {
        char[] chars = new char[count * 2];
        int charIdx = 0;
        while (count-- > 0) {
            charIdx += Character.toChars(codePoints[offset++], chars, charIdx);
        }
        return String.valueOf(chars, 0, charIdx);
    }

    public String(String other) {
        this.value = other.toString();
    }

    public String(StringBuffer sb) {
        this.value = sb.toString();
    }

    public String(StringBuilder sb) {
        this.value = sb.toString();
    }

    private NativeString asNativeString() {
        return (NativeString)JsUtils.uncheckedCast(this);
    }

    @Override
    public char charAt(int index) {
        InternalPreconditions.checkStringElementIndex(index, this.length());
        return this.asNativeString().charCodeAt(index);
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this, index, this.length());
    }

    public int codePointBefore(int index) {
        return Character.codePointBefore(this, index, 0);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return Character.codePointCount(this, beginIndex, endIndex);
    }

    @Override
    public int compareTo(String other) {
        double b;
        double a = (Double)JsUtils.uncheckedCast(this);
        return a == (b = ((Double)JsUtils.uncheckedCast(other)).doubleValue()) ? 0 : (a < b ? -1 : 1);
    }

    public int compareToIgnoreCase(String other) {
        return this.toLowerCase().compareTo(other.toLowerCase());
    }

    public String concat(String str) {
        return this.value + InternalPreconditions.checkNotNull(str);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) != -1;
    }

    public boolean contentEquals(CharSequence cs) {
        return this.equals(cs.toString());
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.equals(sb.toString());
    }

    public boolean endsWith(String suffix) {
        int suffixlength = suffix.length();
        return this.asNativeString().substr(this.length() - suffixlength, suffixlength).equals(suffix);
    }

    public boolean equals(Object other) {
        return this.value == other;
    }

    public boolean equalsIgnoreCase(String other) {
        if (this.equals(other)) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.length() == other.length() && this.toLowerCase().equals(other.toLowerCase());
    }

    public byte[] getBytes() {
        return this.getBytes(EmulatedCharset.UTF_8);
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.getBytes(String.getCharset(charsetName));
    }

    public byte[] getBytes(Charset charset) {
        return ((EmulatedCharset)charset).getBytes(this);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        InternalPreconditions.checkCriticalStringBounds(srcBegin, srcEnd, this.length());
        InternalPreconditions.checkCriticalStringBounds(dstBegin, dstBegin + (srcEnd - srcBegin), dst.length);
        this.getChars0(srcBegin, srcEnd, dst, dstBegin);
    }

    private void getChars0(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.charAt(srcBegin++);
        }
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.length(); ++i) {
            h = (h << 5) - h + this.charAt(i);
        }
        return h;
    }

    public int indexOf(int codePoint) {
        return this.indexOf(String.fromCodePoint(codePoint));
    }

    public int indexOf(int codePoint, int startIndex) {
        return this.indexOf(String.fromCodePoint(codePoint), startIndex);
    }

    public int indexOf(String str) {
        return this.asNativeString().indexOf(str);
    }

    public int indexOf(String str, int startIndex) {
        return this.asNativeString().indexOf(str, startIndex);
    }

    public String intern() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int lastIndexOf(int codePoint) {
        return this.lastIndexOf(String.fromCodePoint(codePoint));
    }

    public int lastIndexOf(int codePoint, int startIndex) {
        return this.lastIndexOf(String.fromCodePoint(codePoint), startIndex);
    }

    public int lastIndexOf(String str) {
        return this.asNativeString().lastIndexOf(str);
    }

    public int lastIndexOf(String str, int start) {
        return this.asNativeString().lastIndexOf(str, start);
    }

    @Override
    public int length() {
        return this.asNativeString().length;
    }

    public boolean matches(String regex) {
        return new NativeRegExp("^(" + regex + ")$").test(this);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return Character.offsetByCodePoints(this, index, codePointOffset);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        InternalPreconditions.checkNotNull(other);
        if (toffset < 0 || ooffset < 0) {
            return false;
        }
        if (toffset + len > this.length() || ooffset + len > other.length()) {
            return false;
        }
        if (len <= 0) {
            return true;
        }
        String left = this.asNativeString().substr(toffset, len);
        String right = other.asNativeString().substr(ooffset, len);
        return ignoreCase ? left.equalsIgnoreCase(right) : left.equals(right);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        return this.regionMatches(false, toffset, other, ooffset, len);
    }

    public String repeat(int count) {
        InternalPreconditions.checkArgument(count >= 0);
        return this.asNativeString().repeat(count);
    }

    public String replace(char from, char to) {
        return StringUtil.replace(this, from, to, false);
    }

    public String replace(CharSequence from, CharSequence to) {
        return StringUtil.replace(this, from, to, false);
    }

    public String replaceAll(String regex, String replace) {
        return StringUtil.replaceAll(this, regex, replace, false);
    }

    public String replaceFirst(String regex, String replace) {
        return StringUtil.replaceFirst(this, regex, replace, false);
    }

    public String nativeReplace(NativeRegExp regExp, char replacement) {
        return this.asNativeString().replace(regExp, NativeString.fromCharCode(replacement));
    }

    public String nativeReplace(NativeRegExp regExp, String replacement) {
        return this.asNativeString().replace(regExp, replacement);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public String[] split(String regex, int maxMatch) {
        NativeRegExp compiled = new NativeRegExp(regex, "g");
        String[] out = new String[]{};
        int count = 0;
        String trail = this;
        String lastTrail = null;
        while (true) {
            NativeRegExp.Match matchObj;
            if ((matchObj = compiled.exec(trail)) == null || trail == "" || count == maxMatch - 1 && maxMatch > 0) break;
            int matchIndex = matchObj.getIndex();
            out[count] = trail.substring(0, matchIndex);
            trail = trail.substring(matchIndex + matchObj.getAt(0).length(), trail.length());
            compiled.setLastIndex(0);
            if (lastTrail == trail) {
                out[count] = trail.substring(0, 1);
                trail = trail.substring(1);
            }
            lastTrail = trail;
            ++count;
        }
        out[count] = trail;
        if (maxMatch == 0 && this.length() > 0) {
            int lastNonEmpty;
            for (lastNonEmpty = out.length; lastNonEmpty > 0 && out[lastNonEmpty - 1] == ""; --lastNonEmpty) {
            }
            if (lastNonEmpty < out.length) {
                ArrayHelper.setLength(out, lastNonEmpty);
            }
        }
        return out;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        return toffset >= 0 && this.asNativeString().substr(toffset, prefix.length()).equals(prefix);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String substring(int beginIndex) {
        InternalPreconditions.checkStringElementIndex(beginIndex, this.length() + 1);
        return this.asNativeString().substr(beginIndex);
    }

    public String substring(int beginIndex, int endIndex) {
        InternalPreconditions.checkStringBounds(beginIndex, endIndex, this.length());
        return this.asNativeString().substr(beginIndex, endIndex - beginIndex);
    }

    public char[] toCharArray() {
        int n = this.length();
        char[] charArr = new char[n];
        this.getChars0(0, n, charArr, 0);
        return charArr;
    }

    public String toLowerCase() {
        return this.asNativeString().toLowerCase();
    }

    public String toLowerCase(Locale locale) {
        return locale == Locale.getDefault() ? this.asNativeString().toLocaleLowerCase() : this.asNativeString().toLowerCase();
    }

    public String toUpperCase() {
        return this.asNativeString().toUpperCase();
    }

    public String toUpperCase(Locale locale) {
        return locale == Locale.getDefault() ? this.asNativeString().toLocaleUpperCase() : this.asNativeString().toUpperCase();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String trim() {
        int end;
        int start;
        int length = this.length();
        for (start = 0; start < length && this.charAt(start) <= ' '; ++start) {
        }
        for (end = length; end > start && this.charAt(end - 1) <= ' '; --end) {
        }
        return start > 0 || end < length ? this.substring(start, end) : this;
    }

    static boolean $isInstance(Object instance) {
        return "string".equals(JsUtils.typeOf(instance));
    }

    @JsType(isNative=true, name="String", namespace="<global>")
    private static class NativeString {
        public int length;

        private NativeString() {
        }

        public static native String fromCodePoint(int var0);

        public static native String fromCharCode(char var0);

        public native char charCodeAt(int var1);

        public native int indexOf(String var1);

        public native int indexOf(String var1, int var2);

        public native int lastIndexOf(String var1);

        public native int lastIndexOf(String var1, int var2);

        public native String repeat(int var1);

        public native String replace(NativeRegExp var1, String var2);

        public native String substr(int var1);

        public native String substr(int var1, int var2);

        public native String toLocaleLowerCase();

        public native String toLocaleUpperCase();

        public native String toLowerCase();

        public native String toUpperCase();
    }

    @JsType(isNative=true, name="Function", namespace="<global>")
    private static class NativeFunction {
        private NativeFunction() {
        }

        public native String apply(String var1, Object[] var2);
    }
}

