/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.BitLevel;
import java.math.Elementary;
import java.math.Multiplication;

class Division {
    Division() {
    }

    static int[] divide(int[] quot, int quotLength, int[] a, int aLength, int[] b, int bLength) {
        int[] normA = new int[aLength + 1];
        int[] normB = new int[bLength + 1];
        int normBLength = bLength;
        int divisorShift = Integer.numberOfLeadingZeros(b[bLength - 1]);
        if (divisorShift != 0) {
            BitLevel.shiftLeft(normB, b, 0, divisorShift);
            BitLevel.shiftLeft(normA, a, 0, divisorShift);
        } else {
            System.arraycopy(a, 0, normA, 0, aLength);
            System.arraycopy(b, 0, normB, 0, bLength);
        }
        int firstDivisorDigit = normB[normBLength - 1];
        int j = aLength;
        for (int i = quotLength - 1; i >= 0; --i) {
            int borrow;
            int guessDigit = 0;
            if (normA[j] == firstDivisorDigit) {
                guessDigit = -1;
            } else {
                long product = (((long)normA[j] & 0xFFFFFFFFL) << 32) + ((long)normA[j - 1] & 0xFFFFFFFFL);
                long res = Division.divideLongByInt(product, firstDivisorDigit);
                guessDigit = (int)res;
                int rem = (int)(res >> 32);
                if (guessDigit != 0) {
                    long leftHand = 0L;
                    long rightHand = 0L;
                    boolean rOverflowed = false;
                    ++guessDigit;
                    do {
                        --guessDigit;
                        if (rOverflowed) break;
                        leftHand = ((long)guessDigit & 0xFFFFFFFFL) * ((long)normB[normBLength - 2] & 0xFFFFFFFFL);
                        rightHand = ((long)rem << 32) + ((long)normA[j - 2] & 0xFFFFFFFFL);
                        long longR = ((long)rem & 0xFFFFFFFFL) + ((long)firstDivisorDigit & 0xFFFFFFFFL);
                        if (Integer.numberOfLeadingZeros((int)(longR >>> 32)) < 32) {
                            rOverflowed = true;
                            continue;
                        }
                        rem = (int)longR;
                    } while ((leftHand ^ Long.MIN_VALUE) > (rightHand ^ Long.MIN_VALUE));
                }
            }
            if (guessDigit != 0 && (borrow = Division.multiplyAndSubtract(normA, j - normBLength, normB, normBLength, guessDigit)) != 0) {
                --guessDigit;
                long carry = 0L;
                for (int k = 0; k < normBLength; ++k) {
                    normA[j - normBLength + k] = (int)(carry += ((long)normA[j - normBLength + k] & 0xFFFFFFFFL) + ((long)normB[k] & 0xFFFFFFFFL));
                    carry >>>= 32;
                }
            }
            if (quot != null) {
                quot[i] = guessDigit;
            }
            --j;
        }
        if (divisorShift != 0) {
            BitLevel.shiftRight(normB, normBLength, normA, 0, divisorShift);
            return normB;
        }
        System.arraycopy(normA, 0, normB, 0, bLength);
        return normA;
    }

    static BigInteger[] divideAndRemainderByInteger(BigInteger val, int divisor, int divisorSign) {
        int[] valDigits = val.digits;
        int valLen = val.numberLength;
        int valSign = val.sign;
        if (valLen == 1) {
            long a = (long)valDigits[0] & 0xFFFFFFFFL;
            long b = (long)divisor & 0xFFFFFFFFL;
            long quo = a / b;
            long rem = a % b;
            if (valSign != divisorSign) {
                quo = -quo;
            }
            if (valSign < 0) {
                rem = -rem;
            }
            return new BigInteger[]{BigInteger.valueOf(quo), BigInteger.valueOf(rem)};
        }
        int quotientLength = valLen;
        int quotientSign = valSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = new int[]{Division.divideArrayByInt(quotientDigits, valDigits, valLen, divisor)};
        BigInteger result0 = new BigInteger(quotientSign, quotientLength, quotientDigits);
        BigInteger result1 = new BigInteger(valSign, 1, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new BigInteger[]{result0, result1};
    }

    static int divideArrayByInt(int[] dest, int[] src, int srcLength, int divisor) {
        long rem = 0L;
        long bLong = (long)divisor & 0xFFFFFFFFL;
        for (int i = srcLength - 1; i >= 0; --i) {
            long quot;
            long temp = rem << 32 | (long)src[i] & 0xFFFFFFFFL;
            if (temp >= 0L) {
                quot = temp / bLong;
                rem = temp % bLong;
            } else {
                long aPos = temp >>> 1;
                long bPos = divisor >>> 1;
                quot = aPos / bPos;
                rem = aPos % bPos;
                rem = (rem << 1) + (temp & 1L);
                if ((divisor & 1) != 0) {
                    if (quot <= rem) {
                        rem -= quot;
                    } else if (quot - rem <= bLong) {
                        rem += bLong - quot;
                        --quot;
                    } else {
                        rem += (bLong << 1) - quot;
                        quot -= 2L;
                    }
                }
            }
            dest[i] = (int)(quot & 0xFFFFFFFFL);
        }
        return (int)rem;
    }

    static long divideLongByInt(long a, int b) {
        long rem;
        long quot;
        long bLong = (long)b & 0xFFFFFFFFL;
        if (a >= 0L) {
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = b >>> 1;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
            if ((b & 1) != 0) {
                if (quot <= rem) {
                    rem -= quot;
                } else if (quot - rem <= bLong) {
                    rem += bLong - quot;
                    --quot;
                } else {
                    rem += (bLong << 1) - quot;
                    quot -= 2L;
                }
            }
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }

    static BigInteger evenModPow(BigInteger base, BigInteger exponent, BigInteger modulus) {
        int j = modulus.getLowestSetBit();
        BigInteger q = modulus.shiftRight(j);
        BigInteger x1 = Division.oddModPow(base, exponent, q);
        BigInteger x2 = Division.pow2ModPow(base, exponent, j);
        BigInteger qInv = Division.modPow2Inverse(q, j);
        BigInteger y = x2.subtract(x1).multiply(qInv);
        Division.inplaceModPow2(y, j);
        if (y.sign < 0) {
            y = y.add(BigInteger.getPowerOfTwo(j));
        }
        return x1.add(q.multiply(y));
    }

    static BigInteger finalSubtraction(int[] res, BigInteger modulus) {
        boolean doSub;
        int modulusLen = modulus.numberLength;
        boolean bl = doSub = res[modulusLen] != 0;
        if (!doSub) {
            int[] modulusDigits = modulus.digits;
            doSub = true;
            for (int i = modulusLen - 1; i >= 0; --i) {
                if (res[i] == modulusDigits[i]) continue;
                doSub = res[i] != 0 && ((long)res[i] & 0xFFFFFFFFL) > ((long)modulusDigits[i] & 0xFFFFFFFFL);
                break;
            }
        }
        BigInteger result = new BigInteger(1, modulusLen + 1, res);
        if (doSub) {
            Elementary.inplaceSubtract(result, modulus);
        }
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger gcdBinary(BigInteger op1, BigInteger op2) {
        BigInteger swap;
        int lsb1 = op1.getLowestSetBit();
        int lsb2 = op2.getLowestSetBit();
        int pow2Count = Math.min(lsb1, lsb2);
        BitLevel.inplaceShiftRight(op1, lsb1);
        BitLevel.inplaceShiftRight(op2, lsb2);
        if (op1.compareTo(op2) == 1) {
            swap = op1;
            op1 = op2;
            op2 = swap;
        }
        do {
            if (op2.numberLength == 1 || op2.numberLength == 2 && op2.digits[1] > 0) {
                op2 = BigInteger.valueOf(Division.gcdBinary(op1.longValue(), op2.longValue()));
                break;
            }
            if ((double)op2.numberLength > (double)op1.numberLength * 1.2) {
                if ((op2 = op2.remainder(op1)).signum() != 0) {
                    BitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                }
            } else {
                do {
                    Elementary.inplaceSubtract(op2, op1);
                    BitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                } while (op2.compareTo(op1) >= 0);
            }
            swap = op2;
            op2 = op1;
            op1 = swap;
        } while (op1.sign != 0);
        return op2.shiftLeft(pow2Count);
    }

    static long gcdBinary(long op1, long op2) {
        int lsb1 = Long.numberOfTrailingZeros(op1);
        int lsb2 = Long.numberOfTrailingZeros(op2);
        int pow2Count = Math.min(lsb1, lsb2);
        if (lsb1 != 0) {
            op1 >>>= lsb1;
        }
        if (lsb2 != 0) {
            op2 >>>= lsb2;
        }
        do {
            if (op1 >= op2) {
                op1 -= op2;
                op1 >>>= Long.numberOfTrailingZeros(op1);
                continue;
            }
            op2 -= op1;
            op2 >>>= Long.numberOfTrailingZeros(op2);
        } while (op1 != 0L);
        return op2 << pow2Count;
    }

    static void inplaceModPow2(BigInteger x, int n) {
        int fd = n >> 5;
        if (x.numberLength < fd || x.bitLength() <= n) {
            return;
        }
        int leadingZeros = 32 - (n & 0x1F);
        x.numberLength = fd + 1;
        int n2 = fd;
        x.digits[n2] = x.digits[n2] & (leadingZeros < 32 ? -1 >>> leadingZeros : 0);
        x.cutOffLeadingZeroes();
    }

    static BigInteger modInverseLorencz(BigInteger a, BigInteger modulo) {
        int max = Math.max(a.numberLength, modulo.numberLength);
        int[] uDigits = new int[max + 1];
        int[] vDigits = new int[max + 1];
        System.arraycopy(modulo.digits, 0, uDigits, 0, modulo.numberLength);
        System.arraycopy(a.digits, 0, vDigits, 0, a.numberLength);
        BigInteger u = new BigInteger(modulo.sign, modulo.numberLength, uDigits);
        BigInteger v = new BigInteger(a.sign, a.numberLength, vDigits);
        BigInteger r = new BigInteger(0, 1, new int[max + 1]);
        BigInteger s = new BigInteger(1, 1, new int[max + 1]);
        s.digits[0] = 1;
        int coefU = 0;
        int coefV = 0;
        int n = modulo.bitLength();
        while (!Division.isPowerOfTwo(u, coefU) && !Division.isPowerOfTwo(v, coefV)) {
            int k = Division.howManyIterations(u, n);
            if (k != 0) {
                BitLevel.inplaceShiftLeft(u, k);
                if (coefU >= coefV) {
                    BitLevel.inplaceShiftLeft(r, k);
                } else {
                    BitLevel.inplaceShiftRight(s, Math.min(coefV - coefU, k));
                    if (k - (coefV - coefU) > 0) {
                        BitLevel.inplaceShiftLeft(r, k - coefV + coefU);
                    }
                }
                coefU += k;
            }
            if ((k = Division.howManyIterations(v, n)) != 0) {
                BitLevel.inplaceShiftLeft(v, k);
                if (coefV >= coefU) {
                    BitLevel.inplaceShiftLeft(s, k);
                } else {
                    BitLevel.inplaceShiftRight(r, Math.min(coefU - coefV, k));
                    if (k - (coefU - coefV) > 0) {
                        BitLevel.inplaceShiftLeft(s, k - coefU + coefV);
                    }
                }
                coefV += k;
            }
            if (u.signum() == v.signum()) {
                if (coefU <= coefV) {
                    Elementary.completeInPlaceSubtract(u, v);
                    Elementary.completeInPlaceSubtract(r, s);
                } else {
                    Elementary.completeInPlaceSubtract(v, u);
                    Elementary.completeInPlaceSubtract(s, r);
                }
            } else if (coefU <= coefV) {
                Elementary.completeInPlaceAdd(u, v);
                Elementary.completeInPlaceAdd(r, s);
            } else {
                Elementary.completeInPlaceAdd(v, u);
                Elementary.completeInPlaceAdd(s, r);
            }
            if (v.signum() != 0 && u.signum() != 0) continue;
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (Division.isPowerOfTwo(v, coefV)) {
            r = s;
            if (v.signum() != u.signum()) {
                u = u.negate();
            }
        }
        if (u.testBit(n)) {
            r = r.signum() < 0 ? r.negate() : modulo.subtract(r);
        }
        if (r.signum() < 0) {
            r = r.add(modulo);
        }
        return r;
    }

    static BigInteger modInverseMontgomery(BigInteger a, BigInteger p) {
        int lsbv;
        if (a.sign == 0) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (!p.testBit(0)) {
            return Division.modInverseLorencz(a, p);
        }
        int m = p.numberLength * 32;
        BigInteger u = p.copy();
        BigInteger v = a.copy();
        int max = Math.max(v.numberLength, u.numberLength);
        BigInteger r = new BigInteger(1, 1, new int[max + 1]);
        BigInteger s = new BigInteger(1, 1, new int[max + 1]);
        s.digits[0] = 1;
        int k = 0;
        int lsbu = u.getLowestSetBit();
        if (lsbu > (lsbv = v.getLowestSetBit())) {
            BitLevel.inplaceShiftRight(u, lsbu);
            BitLevel.inplaceShiftRight(v, lsbv);
            BitLevel.inplaceShiftLeft(r, lsbv);
            k += lsbu - lsbv;
        } else {
            BitLevel.inplaceShiftRight(u, lsbu);
            BitLevel.inplaceShiftRight(v, lsbv);
            BitLevel.inplaceShiftLeft(s, lsbu);
            k += lsbv - lsbu;
        }
        r.sign = 1;
        block0: while (v.signum() > 0) {
            int toShift;
            while (u.compareTo(v) > 0) {
                Elementary.inplaceSubtract(u, v);
                toShift = u.getLowestSetBit();
                BitLevel.inplaceShiftRight(u, toShift);
                Elementary.inplaceAdd(r, s);
                BitLevel.inplaceShiftLeft(s, toShift);
                k += toShift;
            }
            while (u.compareTo(v) <= 0) {
                Elementary.inplaceSubtract(v, u);
                if (v.signum() == 0) continue block0;
                toShift = v.getLowestSetBit();
                BitLevel.inplaceShiftRight(v, toShift);
                Elementary.inplaceAdd(s, r);
                BitLevel.inplaceShiftLeft(r, toShift);
                k += toShift;
            }
        }
        if (!u.isOne()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (r.compareTo(p) >= 0) {
            Elementary.inplaceSubtract(r, p);
        }
        r = p.subtract(r);
        int n1 = Division.calcN(p);
        if (k > m) {
            r = Division.monPro(r, BigInteger.ONE, p, n1);
            k -= m;
        }
        r = Division.monPro(r, BigInteger.getPowerOfTwo(m - k), p, n1);
        return r;
    }

    static BigInteger modPow2Inverse(BigInteger x, int n) {
        BigInteger y = new BigInteger(1, new int[1 << n]);
        y.numberLength = 1;
        y.digits[0] = 1;
        y.sign = 1;
        for (int i = 1; i < n; ++i) {
            if (!BitLevel.testBit(x.multiply(y), i)) continue;
            int n2 = i >> 5;
            y.digits[n2] = y.digits[n2] | 1 << (i & 0x1F);
        }
        return y;
    }

    static BigInteger monPro(BigInteger a, BigInteger b, BigInteger modulus, int n2) {
        int modulusLen = modulus.numberLength;
        int[] res = new int[(modulusLen << 1) + 1];
        Multiplication.multArraysPAP(a.digits, Math.min(modulusLen, a.numberLength), b.digits, Math.min(modulusLen, b.numberLength), res);
        Division.monReduction(res, modulus, n2);
        return Division.finalSubtraction(res, modulus);
    }

    static int multiplyAndSubtract(int[] a, int start, int[] b, int bLen, int c) {
        long carry0 = 0L;
        long carry1 = 0L;
        for (int i = 0; i < bLen; ++i) {
            carry0 = Multiplication.unsignedMultAddAdd(b[i], c, (int)carry0, 0);
            carry1 = ((long)a[start + i] & 0xFFFFFFFFL) - (carry0 & 0xFFFFFFFFL) + carry1;
            a[start + i] = (int)carry1;
            carry1 >>= 32;
            carry0 >>>= 32;
        }
        carry1 = ((long)a[start + bLen] & 0xFFFFFFFFL) - carry0 + carry1;
        a[start + bLen] = (int)carry1;
        return (int)(carry1 >> 32);
    }

    static BigInteger oddModPow(BigInteger base, BigInteger exponent, BigInteger modulus) {
        int k = modulus.numberLength << 5;
        BigInteger a2 = base.shiftLeft(k).mod(modulus);
        BigInteger x2 = BigInteger.getPowerOfTwo(k).mod(modulus);
        int n2 = Division.calcN(modulus);
        BigInteger res = modulus.numberLength == 1 ? Division.squareAndMultiply(x2, a2, exponent, modulus, n2) : Division.slidingWindow(x2, a2, exponent, modulus, n2);
        return Division.monPro(res, BigInteger.ONE, modulus, n2);
    }

    static BigInteger pow2ModPow(BigInteger base, BigInteger exponent, int j) {
        BigInteger res = BigInteger.ONE;
        BigInteger e = exponent.copy();
        BigInteger baseMod2toN = base.copy();
        if (base.testBit(0)) {
            Division.inplaceModPow2(e, j - 1);
        }
        Division.inplaceModPow2(baseMod2toN, j);
        for (int i = e.bitLength() - 1; i >= 0; --i) {
            BigInteger res2 = res.copy();
            Division.inplaceModPow2(res2, j);
            res = res.multiply(res2);
            if (!BitLevel.testBit(e, i)) continue;
            res = res.multiply(baseMod2toN);
            Division.inplaceModPow2(res, j);
        }
        Division.inplaceModPow2(res, j);
        return res;
    }

    static int remainder(BigInteger dividend, int divisor) {
        return Division.remainderArrayByInt(dividend.digits, dividend.numberLength, divisor);
    }

    static int remainderArrayByInt(int[] src, int srcLength, int divisor) {
        long result = 0L;
        for (int i = srcLength - 1; i >= 0; --i) {
            long temp = (result << 32) + ((long)src[i] & 0xFFFFFFFFL);
            long res = Division.divideLongByInt(temp, divisor);
            result = (int)(res >> 32);
        }
        return (int)result;
    }

    static BigInteger slidingWindow(BigInteger x2, BigInteger a2, BigInteger exponent, BigInteger modulus, int n2) {
        int i;
        BigInteger[] pows = new BigInteger[8];
        BigInteger res = x2;
        pows[0] = a2;
        BigInteger x3 = Division.monPro(a2, a2, modulus, n2);
        for (i = 1; i <= 7; ++i) {
            pows[i] = Division.monPro(pows[i - 1], x3, modulus, n2);
        }
        for (i = exponent.bitLength() - 1; i >= 0; --i) {
            if (BitLevel.testBit(exponent, i)) {
                int j;
                int lowexp = 1;
                int acc3 = i;
                for (j = Math.max(i - 3, 0); j <= i - 1; ++j) {
                    if (!BitLevel.testBit(exponent, j)) continue;
                    if (j < acc3) {
                        acc3 = j;
                        lowexp = lowexp << i - j ^ 1;
                        continue;
                    }
                    lowexp ^= 1 << j - acc3;
                }
                for (j = acc3; j <= i; ++j) {
                    res = Division.monPro(res, res, modulus, n2);
                }
                res = Division.monPro(pows[lowexp - 1 >> 1], res, modulus, n2);
                i = acc3;
                continue;
            }
            res = Division.monPro(res, res, modulus, n2);
        }
        return res;
    }

    static BigInteger squareAndMultiply(BigInteger x2, BigInteger a2, BigInteger exponent, BigInteger modulus, int n2) {
        BigInteger res = x2;
        for (int i = exponent.bitLength() - 1; i >= 0; --i) {
            res = Division.monPro(res, res, modulus, n2);
            if (!BitLevel.testBit(exponent, i)) continue;
            res = Division.monPro(res, a2, modulus, n2);
        }
        return res;
    }

    private static int calcN(BigInteger a) {
        long m0 = (long)a.digits[0] & 0xFFFFFFFFL;
        long n2 = 1L;
        long powerOfTwo = 2L;
        do {
            if ((m0 * n2 & powerOfTwo) == 0L) continue;
            n2 |= powerOfTwo;
        } while ((powerOfTwo <<= 1) < 0x100000000L);
        n2 = -n2;
        return (int)(n2 & 0xFFFFFFFFL);
    }

    private static int howManyIterations(BigInteger bi, int n) {
        int i = n - 1;
        if (bi.sign > 0) {
            while (!bi.testBit(i)) {
                --i;
            }
            return n - 1 - i;
        }
        while (bi.testBit(i)) {
            --i;
        }
        return n - 1 - Math.max(i, bi.getLowestSetBit());
    }

    private static boolean isPowerOfTwo(BigInteger bi, int exp) {
        boolean result = false;
        boolean bl = result = exp >> 5 == bi.numberLength - 1 && bi.digits[bi.numberLength - 1] == 1 << (exp & 0x1F);
        if (result) {
            for (int i = 0; result && i < bi.numberLength - 1; ++i) {
                result = bi.digits[i] == 0;
            }
        }
        return result;
    }

    private static void monReduction(int[] res, BigInteger modulus, int n2) {
        int[] modulusDigits = modulus.digits;
        int modulusLen = modulus.numberLength;
        long outerCarry = 0L;
        for (int i = 0; i < modulusLen; ++i) {
            long innnerCarry = 0L;
            int m = (int)Multiplication.unsignedMultAddAdd(res[i], n2, 0, 0);
            for (int j = 0; j < modulusLen; ++j) {
                innnerCarry = Multiplication.unsignedMultAddAdd(m, modulusDigits[j], res[i + j], (int)innnerCarry);
                res[i + j] = (int)innnerCarry;
                innnerCarry >>>= 32;
            }
            res[i + modulusLen] = (int)(outerCarry += ((long)res[i + modulusLen] & 0xFFFFFFFFL) + innnerCarry);
            outerCarry >>>= 32;
        }
        res[modulusLen << 1] = (int)outerCarry;
        for (int j = 0; j < modulusLen + 1; ++j) {
            res[j] = res[j + modulusLen];
        }
    }
}

