/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;
import java.math.RoundingMode;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.NativeRegExp;

public final class MathContext
implements Serializable {
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;
    private RoundingMode roundingMode;

    public MathContext(int precision) {
        this(precision, RoundingMode.HALF_UP);
    }

    public MathContext(int precision, RoundingMode roundingMode) {
        InternalPreconditions.checkCriticalArgument(precision >= 0, "Digits < 0");
        InternalPreconditions.checkNotNull((Object)roundingMode, "null RoundingMode");
        this.precision = precision;
        this.roundingMode = roundingMode;
    }

    public MathContext(String val) {
        InternalPreconditions.checkNotNull(val, "null string");
        NativeRegExp.Match match = new NativeRegExp("^precision=(\\d+)\\ roundingMode=(\\w+)$").exec(val);
        if (match == null || match.getLength() != 3) {
            throw new IllegalArgumentException("bad string format");
        }
        try {
            this.precision = Integer.parseInt(match.getAt(1));
            this.roundingMode = RoundingMode.valueOf(match.getAt(2));
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("bad string format");
        }
        InternalPreconditions.checkCriticalArgument(this.precision >= 0, "Digits < 0");
    }

    public boolean equals(Object x) {
        return x instanceof MathContext && ((MathContext)x).getPrecision() == this.precision && ((MathContext)x).getRoundingMode() == this.roundingMode;
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public int hashCode() {
        return this.precision << 3 | this.roundingMode.ordinal();
    }

    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + (Object)((Object)this.roundingMode);
    }
}

