/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.util.Arrays;

public class SHA256Digest
extends MessageDigest {
    private static final int WORD_LENGTH = 32;
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] H = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private int[] hash = new int[8];
    private byte[] wordBuffer = new byte[4];
    private int wordOff;
    private int[] blockBuffer = new int[64];
    private int blockOff;
    private long byteCounter;

    SHA256Digest() {
        super("SHA-256");
        this.engineReset();
    }

    @Override
    protected void engineReset() {
        System.arraycopy(H, 0, this.hash, 0, 8);
        Arrays.fill(this.wordBuffer, (byte)0);
        Arrays.fill(this.blockBuffer, 0);
        this.wordOff = 0;
        this.blockOff = 0;
        this.byteCounter = 0L;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.wordBuffer[this.wordOff] = input;
        ++this.wordOff;
        ++this.byteCounter;
        if (this.wordOff == 4) {
            this.updateWord();
            this.wordOff = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int inOff, int len) {
        for (int i = 0; i < len; ++i) {
            this.engineUpdate(input[inOff + i]);
        }
    }

    @Override
    protected byte[] engineDigest() {
        this.doPadding();
        byte[] result = new byte[32];
        for (int i = 0; i < 8; ++i) {
            this.int2bytes(this.hash[i], result, i * 4);
        }
        this.engineReset();
        return result;
    }

    private void int2bytes(int input, byte[] output, int outOff) {
        output[outOff] = (byte)(input >>> 24 & 0xFF);
        output[outOff + 1] = (byte)(input >>> 16 & 0xFF);
        output[outOff + 2] = (byte)(input >>> 8 & 0xFF);
        output[outOff + 3] = (byte)(input & 0xFF);
    }

    private void doPadding() {
        long length = this.byteCounter << 3;
        this.engineUpdate((byte)-128);
        while (this.wordOff != 0) {
            this.engineUpdate((byte)0);
        }
        Arrays.fill(this.blockBuffer, this.blockOff, 64, 0);
        if (this.blockOff > 14) {
            this.computeBlock();
            Arrays.fill(this.blockBuffer, 0);
        }
        this.blockBuffer[14] = (int)(length >>> 32);
        this.blockBuffer[15] = this.enforceOverflow((int)length);
        this.computeBlock();
    }

    private void updateWord() {
        this.blockBuffer[this.blockOff] = (this.wordBuffer[0] & 0xFF) << 24 | (this.wordBuffer[1] & 0xFF) << 16 | (this.wordBuffer[2] & 0xFF) << 8 | this.wordBuffer[3] & 0xFF;
        ++this.blockOff;
        if (this.blockOff == 16) {
            this.computeBlock();
        }
    }

    private void computeBlock() {
        for (int t = 16; t < this.blockBuffer.length; ++t) {
            this.blockBuffer[t] = this.enforceOverflow(this.sigma1(this.blockBuffer[t - 2]) + this.blockBuffer[t - 7] + this.sigma0(this.blockBuffer[t - 15]) + this.blockBuffer[t - 16]);
        }
        int a = this.hash[0];
        int b = this.hash[1];
        int c = this.hash[2];
        int d = this.hash[3];
        int e = this.hash[4];
        int f = this.hash[5];
        int g = this.hash[6];
        int h = this.hash[7];
        for (int t = 0; t < 64; ++t) {
            int t1 = h + this.sum1(e) + this.ch(e, f, g) + K[t] + this.blockBuffer[t];
            int t2 = this.sum0(a) + this.maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = this.enforceOverflow(d + t1);
            d = c;
            c = b;
            b = a;
            a = this.enforceOverflow(t1 + t2);
        }
        this.hash[0] = this.enforceOverflow(a + this.hash[0]);
        this.hash[1] = this.enforceOverflow(b + this.hash[1]);
        this.hash[2] = this.enforceOverflow(c + this.hash[2]);
        this.hash[3] = this.enforceOverflow(d + this.hash[3]);
        this.hash[4] = this.enforceOverflow(e + this.hash[4]);
        this.hash[5] = this.enforceOverflow(f + this.hash[5]);
        this.hash[6] = this.enforceOverflow(g + this.hash[6]);
        this.hash[7] = this.enforceOverflow(h + this.hash[7]);
        this.blockOff = 0;
    }

    private int sum0(int x) {
        return this.rightRotate(x, 2) ^ this.rightRotate(x, 13) ^ this.rightRotate(x, 22);
    }

    private int sum1(int x) {
        return this.rightRotate(x, 6) ^ this.rightRotate(x, 11) ^ this.rightRotate(x, 25);
    }

    private int sigma0(int x) {
        return this.rightRotate(x, 7) ^ this.rightRotate(x, 18) ^ x >>> 3;
    }

    private int sigma1(int x) {
        return this.rightRotate(x, 17) ^ this.rightRotate(x, 19) ^ x >>> 10;
    }

    private int rightRotate(int x, int n) {
        return x >>> n | this.enforceOverflow(x << 32 - n);
    }

    private int ch(int x, int y, int z) {
        return this.enforceOverflow(x & y ^ ~x & z);
    }

    private int maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private int enforceOverflow(int input) {
        return input & 0xFFFFFFFF;
    }
}

