/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.Date;
import java.sql.Time;

public class Timestamp
extends java.util.Date {
    private int nanos;

    public static Timestamp valueOf(String s) {
        String[] components = s.split(" ");
        if (components.length != 2) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        String[] timeComponents = components[1].split("\\.");
        boolean hasNanos = true;
        int nanos = 0;
        if (timeComponents.length == 1) {
            hasNanos = false;
        } else if (timeComponents.length != 2) {
            throw new IllegalArgumentException("Invalid escape format: " + s);
        }
        Date d = Date.valueOf(components[0]);
        Time t = Time.valueOf(timeComponents[0]);
        if (hasNanos) {
            String nanosString = timeComponents[1];
            int len = nanosString.length();
            assert (len > 0);
            if (len > 9) {
                throw new IllegalArgumentException("Invalid escape format: " + s);
            }
            if (len < 9) {
                nanosString = nanosString + "00000000".substring(len - 1);
            }
            try {
                nanos = Integer.valueOf(nanosString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape format: " + s);
            }
        }
        return new Timestamp(d.getYear(), d.getMonth(), d.getDate(), t.getHours(), t.getMinutes(), t.getSeconds(), nanos);
    }

    private static String padNine(int value) {
        StringBuilder toReturn = new StringBuilder("000000000");
        assert (toReturn.length() == 9);
        String asString = String.valueOf(value);
        toReturn = toReturn.replace(9 - asString.length(), 9, asString);
        assert (toReturn.length() == 9);
        return toReturn.toString();
    }

    @Deprecated
    public Timestamp(int year, int month, int date, int hour, int minute, int second, int nano) {
        super(year, month, date, hour, minute, second);
        this.setNanos(nano);
    }

    public Timestamp(long time) {
        super(time);
        this.nanos = (int)(time % 1000L) * 1000000;
    }

    public boolean after(Timestamp ts) {
        return this.getTime() > ts.getTime() || this.getTime() == ts.getTime() && this.getNanos() > ts.getNanos();
    }

    public boolean before(Timestamp ts) {
        return this.getTime() < ts.getTime() || this.getTime() == ts.getTime() && this.getNanos() < ts.getNanos();
    }

    @Override
    public int compareTo(java.util.Date o) {
        if (o instanceof Timestamp) {
            return this.compareTo((Timestamp)o);
        }
        return this.compareTo(new Timestamp(o.getTime()));
    }

    @Override
    public int compareTo(Timestamp o) {
        int cmp = Long.compare(this.getTime(), o.getTime());
        return cmp == 0 ? Integer.compare(this.getNanos(), o.getNanos()) : cmp;
    }

    @Override
    public boolean equals(Object ts) {
        return ts instanceof Timestamp && this.equals((Timestamp)ts);
    }

    public boolean equals(Timestamp ts) {
        return ts != null && this.getTime() == ts.getTime() && this.getNanos() == ts.getNanos();
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public long getTime() {
        return super.getTime();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setNanos(int n) {
        if (n < 0 || n > 999999999) {
            throw new IllegalArgumentException("nanos out of range " + n);
        }
        this.nanos = n;
        super.setTime(this.getTime() / 1000L * 1000L + (long)(this.nanos / 1000000));
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.nanos = (int)(time % 1000L) * 1000000;
    }

    @Override
    public String toString() {
        return String.valueOf(1900 + this.getYear()) + "-" + Timestamp.padTwo(1 + this.getMonth()) + "-" + Timestamp.padTwo(this.getDate()) + " " + Timestamp.padTwo(this.getHours()) + ":" + Timestamp.padTwo(this.getMinutes()) + ":" + Timestamp.padTwo(this.getSeconds()) + "." + Timestamp.padNine(this.getNanos());
    }
}

