/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Queue;
import javaemul.internal.InternalPreconditions;

public abstract class AbstractQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    protected AbstractQueue() {
    }

    @Override
    public boolean add(E o) {
        InternalPreconditions.checkState(this.offer(o), "Unable to add element to queue");
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        InternalPreconditions.checkNotNull(c);
        InternalPreconditions.checkArgument(c != this, "Can't add a queue to itself");
        return super.addAll(c);
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public E element() {
        Object e = this.peek();
        InternalPreconditions.checkElement(e != null, "Queue is empty");
        return e;
    }

    @Override
    public E remove() {
        Object e = this.poll();
        InternalPreconditions.checkElement(e != null, "Queue is empty");
        return e;
    }
}

