/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javaemul.internal.ArrayHelper;
import javaemul.internal.InternalPreconditions;

abstract class ArrayListBase<E>
extends AbstractList<E>
implements List<E>,
Cloneable,
RandomAccess,
Serializable {
    E[] array;

    ArrayListBase() {
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.sizeImpl(), c);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public E get(int index) {
        InternalPreconditions.checkElementIndex(index, this.sizeImpl());
        return this.array[index];
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;
            int last = -1;

            @Override
            public boolean hasNext() {
                return this.i < ArrayListBase.this.sizeImpl();
            }

            @Override
            public E next() {
                InternalPreconditions.checkElement(this.hasNext());
                this.last = this.i++;
                return ArrayListBase.this.array[this.last];
            }

            @Override
            public void remove() {
                InternalPreconditions.checkState(this.last != -1);
                this.i = this.last;
                ArrayListBase.this.removeImpl(this.i);
                this.last = -1;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        InternalPreconditions.checkNotNull(consumer);
        int size = this.sizeImpl();
        for (int i = 0; i < size; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lastIndexOf(o, this.sizeImpl() - 1);
    }

    @Override
    public E remove(int index) {
        E previous = this.get(index);
        this.removeImpl(index);
        return previous;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeImpl(i);
        return true;
    }

    abstract void removeImpl(int var1);

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        InternalPreconditions.checkNotNull(filter);
        int newIndex = 0;
        int size = this.sizeImpl();
        for (int index = 0; index < size; ++index) {
            E e = this.array[index];
            if (filter.test(e)) continue;
            if (newIndex != index) {
                this.array[newIndex] = e;
            }
            ++newIndex;
        }
        if (newIndex != size) {
            this.setSize(newIndex);
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        InternalPreconditions.checkNotNull(operator);
        int size = this.sizeImpl();
        for (int i = 0; i < size; ++i) {
            this.array[i] = operator.apply(this.array[i]);
        }
    }

    @Override
    public E set(int index, E o) {
        E previous = this.get(index);
        this.array[index] = o;
        return previous;
    }

    @Override
    public int size() {
        return this.sizeImpl();
    }

    abstract int sizeImpl();

    @Override
    public <T> T[] toArray(T[] out) {
        int size = this.sizeImpl();
        if (out.length < size) {
            out = ArrayHelper.createFrom(out, size);
        }
        for (int i = 0; i < size; ++i) {
            out[i] = this.array[i];
        }
        if (out.length > size) {
            out[size] = null;
        }
        return out;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.array, 0, this.sizeImpl(), c);
    }

    int indexOf(Object o, int index) {
        int size = this.sizeImpl();
        while (index < size) {
            if (Objects.equals(o, this.array[index])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int lastIndexOf(Object o, int index) {
        while (index >= 0) {
            if (Objects.equals(o, this.array[index])) {
                return index;
            }
            --index;
        }
        return -1;
    }

    abstract void setSize(int var1);
}

