/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Comparators;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsNonNull;

public class Collections {
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    public static final Set EMPTY_SET = new EmptySet();

    public static <T> Collection<T> synchronizedCollection(Collection<T> c) {
        return c;
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list;
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> m) {
        return m;
    }

    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> m) {
        return m;
    }

    public static <T> NavigableSet<T> synchronizedNavigableSet(NavigableSet<T> s) {
        return s;
    }

    public static <T> Set<T> synchronizedSet(Set<T> s) {
        return s;
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> m) {
        return m;
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> s) {
        return s;
    }

    public static <T> boolean addAll(Collection<? super T> c, T ... a) {
        boolean result = false;
        for (T e : a) {
            result |= c.add(e);
        }
        return result;
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new LifoQueue<T>(deque);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> sortedList, T key) {
        return Collections.binarySearch(sortedList, key, null);
    }

    public static <T> int binarySearch(List<? extends T> sortedList, T key, Comparator<? super T> comparator) {
        comparator = Comparators.nullToNaturalOrder(comparator);
        int low = 0;
        int high = sortedList.size() - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            T midVal = sortedList.get(mid);
            int compareResult = comparator.compare(midVal, key);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static <T> void copy(List<? super T> dest, List<? extends T> src) {
        if (src.size() > dest.size()) {
            throw new IndexOutOfBoundsException("src does not fit in dest");
        }
        ListIterator<T> destIt = dest.listIterator();
        for (T e : src) {
            destIt.next();
            destIt.set(e);
        }
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        Collection<?> iterating = c1;
        Collection<?> testing = c2;
        if (c1 instanceof Set && !(c2 instanceof Set)) {
            iterating = c2;
            testing = c1;
        }
        for (Object o : iterating) {
            if (!testing.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyListIterator.INSTANCE;
    }

    public static <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EmptyListIterator.INSTANCE;
    }

    public static <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> Enumeration<T> enumeration(Collection<T> c) {
        final Iterator<T> it = c.iterator();
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public T nextElement() {
                return it.next();
            }
        };
    }

    public static <T> void fill(List<? super T> list, T obj) {
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(obj);
        }
    }

    public static int frequency(Collection<?> c, Object o) {
        int count = 0;
        for (Object e : c) {
            if (!Objects.equals(o, e)) continue;
            ++count;
        }
        return count;
    }

    public static <T> ArrayList<T> list(Enumeration<T> e) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (e.hasMoreElements()) {
            arrayList.add(e.nextElement());
        }
        return arrayList;
    }

    public static <T> T max(Collection<? extends T> coll) {
        return Collections.max(coll, null);
    }

    public static <T> T max(Collection<? extends T> coll, Comparator<? super T> comp) {
        comp = Comparators.nullToNaturalOrder(comp);
        Iterator<T> it = coll.iterator();
        T max = it.next();
        while (it.hasNext()) {
            T t = it.next();
            if (comp.compare(t, max) <= 0) continue;
            max = t;
        }
        return max;
    }

    public static <T> T min(Collection<? extends T> coll) {
        return Collections.min(coll, null);
    }

    public static <T> T min(Collection<? extends T> coll, Comparator<? super T> comp) {
        return Collections.max(coll, Collections.reverseOrder(comp));
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        InternalPreconditions.checkArgument(map.isEmpty(), "map is not empty");
        return new SetFromMap<E>(map);
    }

    public static <T> List<T> nCopies(int n, T o) {
        Object[] array = new Object[n];
        if (o != null) {
            Arrays.fill(array, o);
        }
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static <T> boolean replaceAll(List<T> list, T oldVal, T newVal) {
        boolean modified = false;
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            T t = it.next();
            if (!Objects.equals(t, oldVal)) continue;
            it.set(newVal);
            modified = true;
        }
        return modified;
    }

    public static void reverse(List<?> l) {
        if (l instanceof RandomAccess) {
            int iFront = 0;
            for (int iBack = l.size() - 1; iFront < iBack; ++iFront, --iBack) {
                Collections.swap(l, iFront, iBack);
            }
        } else {
            ListIterator<?> head = l.listIterator();
            ListIterator<?> tail = l.listIterator(l.size());
            while (head.nextIndex() < tail.previousIndex()) {
                Object headElem = head.next();
                Object tailElem = tail.previous();
                head.set(tailElem);
                tail.set(headElem);
            }
        }
    }

    public static <T> Comparator<T> reverseOrder() {
        return Comparator.reverseOrder();
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> cmp) {
        return cmp == null ? Collections.reverseOrder() : cmp.reversed();
    }

    public static void rotate(List<?> lst, int dist) {
        InternalPreconditions.checkNotNull(lst);
        int size = lst.size();
        if (size == 0) {
            return;
        }
        int normdist = dist % size;
        if (normdist == 0) {
            return;
        }
        if (normdist < 0) {
            normdist += size;
        }
        if (lst instanceof RandomAccess) {
            List<?> list = lst;
            Object temp = list.get(0);
            int index = 0;
            int beginIndex = 0;
            for (int i = 0; i < size; ++i) {
                index = (index + normdist) % size;
                temp = list.set(index, temp);
                if (index != beginIndex) continue;
                index = ++beginIndex;
                temp = list.get(beginIndex);
            }
        } else {
            int divideIndex = size - normdist;
            List<?> sublist1 = lst.subList(0, divideIndex);
            List<?> sublist2 = lst.subList(divideIndex, size);
            Collections.reverse(sublist1);
            Collections.reverse(sublist2);
            Collections.reverse(lst);
        }
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, RandomHolder.rnd);
    }

    public static void shuffle(List<?> list, Random rnd) {
        if (list instanceof RandomAccess) {
            for (int i = list.size() - 1; i >= 1; --i) {
                Collections.swapImpl(list, i, rnd.nextInt(i + 1));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = arr.length - 1; i >= 1; --i) {
                Collections.swapImpl(arr, i, rnd.nextInt(i + 1));
            }
            ListIterator<?> it = list.listIterator();
            for (Object e : arr) {
                it.next();
                it.set(e);
            }
        }
    }

    public static <T> Set<T> singleton(T o) {
        HashSet<T> set = new HashSet<T>(1);
        set.add(o);
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> singletonList(T o) {
        return new SingletonList<T>(o);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return Collections.unmodifiableMap(map);
    }

    public static <T> void sort(List<T> target) {
        target.sort(null);
    }

    public static <T> void sort(List<T> target, Comparator<? super T> c) {
        target.sort(c);
    }

    public static void swap(List<?> list, int i, int j) {
        Collections.swapImpl(list, i, j);
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> coll) {
        return new UnmodifiableCollection<T>(coll);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    static <E> List<E> internalListOf(E[] elements) {
        if (InternalPreconditions.isApiChecked()) {
            for (int i = 0; i < elements.length; ++i) {
                InternalPreconditions.checkNotNull(elements[i]);
            }
        }
        return new UnmodifiableRandomAccessList(elements.length == 0 ? Collections.emptyList() : Arrays.asList(elements));
    }

    static <E> Set<E> internalSetOf(E[] elements, boolean allowDuplicates) {
        if (elements.length == 0) {
            return Collections.unmodifiableSet(Collections.emptySet());
        }
        HashSet<E> set = new HashSet<E>();
        for (int i = 0; i < elements.length; ++i) {
            boolean added = set.add(InternalPreconditions.checkNotNull(elements[i]));
            if (allowDuplicates) continue;
            InternalPreconditions.checkArgument(added, "Duplicate element");
        }
        return Collections.unmodifiableSet(set);
    }

    @JsMethod
    static <K, V> Map<K, V> internalMapOf(Object ... elements) {
        if (elements.length == 0) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < elements.length; i += 2) {
            Object old = map.put(InternalPreconditions.checkNotNull(elements[i]), InternalPreconditions.checkNotNull(elements[i + 1]));
            InternalPreconditions.checkArgument(old == null, "Duplicate element");
        }
        return Collections.unmodifiableMap(map);
    }

    static <K, V> Map<K, V> internalMapFromEntries(Collection<? extends Map.Entry<? extends K, ? extends V>> entries) {
        if (entries.isEmpty()) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            InternalPreconditions.checkNotNull(entry);
            V old = map.put(InternalPreconditions.checkNotNull(entry.getKey()), InternalPreconditions.checkNotNull(entry.getValue()));
            InternalPreconditions.checkArgument(old == null, "Duplicate element");
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap<K, V>(map);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> map) {
        return new UnmodifiableSortedMap<K, V>(map);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> set) {
        return new UnmodifiableSortedSet<T>(set);
    }

    static <T> int hashCode(Iterable<T> collection) {
        int hashCode = 0;
        for (T e : collection) {
            hashCode += Objects.hashCode(e);
        }
        return hashCode;
    }

    static <T> int hashCode(List<T> list) {
        int hashCode = 1;
        for (T e : list) {
            hashCode = 31 * hashCode + Objects.hashCode(e);
        }
        return hashCode;
    }

    private static <T> void swapImpl(List<T> list, int i, int j) {
        T t = list.get(i);
        list.set(i, list.get(j));
        list.set(j, t);
    }

    private static void swapImpl(Object[] a, int i, int j) {
        Object obj = a[i];
        a[i] = a[j];
        a[j] = obj;
    }

    private Collections() {
    }

    private static class RandomHolder {
        private static final Random rnd = new Random();

        private RandomHolder() {
        }
    }

    private static class UnmodifiableListIterator<T>
    extends UnmodifiableCollectionIterator<T>
    implements ListIterator<T> {
        private final ListIterator<? extends T> lit;

        private UnmodifiableListIterator(ListIterator<? extends T> lit) {
            super(lit);
            this.lit = lit;
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.lit.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.lit.nextIndex();
        }

        @Override
        public T previous() {
            return this.lit.previous();
        }

        @Override
        public int previousIndex() {
            return this.lit.previousIndex();
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableCollectionIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> it;

        private UnmodifiableCollectionIterator(Iterator<? extends T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E> {
        private SortedSet<E> sortedSet;

        public UnmodifiableSortedSet(SortedSet<? extends E> sortedSet) {
            super(sortedSet);
            this.sortedSet = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.sortedSet.comparator();
        }

        @Override
        public boolean equals(Object o) {
            return this.sortedSet.equals(o);
        }

        @Override
        public E first() {
            return this.sortedSet.first();
        }

        @Override
        public int hashCode() {
            return this.sortedSet.hashCode();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new UnmodifiableSortedSet<E>(this.sortedSet.headSet(toElement));
        }

        @Override
        public E last() {
            return this.sortedSet.last();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new UnmodifiableSortedSet<E>(this.sortedSet.subSet(fromElement, toElement));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new UnmodifiableSortedSet<E>(this.sortedSet.tailSet(fromElement));
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V> {
        private SortedMap<K, ? extends V> sortedMap;

        public UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            super(sortedMap);
            this.sortedMap = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public boolean equals(Object o) {
            return this.sortedMap.equals(o);
        }

        @Override
        public K firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        public int hashCode() {
            return this.sortedMap.hashCode();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.headMap(toKey));
        }

        @Override
        public K lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.tailMap(fromKey));
        }
    }

    static class UnmodifiableSet<T>
    extends UnmodifiableCollection<T>
    implements Set<T> {
        public UnmodifiableSet(Set<? extends T> set) {
            super(set);
        }

        public boolean equals(Object o) {
            return this.coll.equals(o);
        }

        public int hashCode() {
            return this.coll.hashCode();
        }
    }

    static class UnmodifiableRandomAccessList<T>
    extends UnmodifiableList<T>
    implements RandomAccess {
        public UnmodifiableRandomAccessList(List<? extends T> list) {
            super(list);
        }
    }

    static class UnmodifiableMap<K, V>
    implements Map<K, V> {
        private UnmodifiableSet<Map.Entry<K, V>> entrySet;
        private UnmodifiableSet<K> keySet;
        private final Map<? extends K, ? extends V> map;
        private UnmodifiableCollection<V> values;

        public UnmodifiableMap(Map<? extends K, ? extends V> map) {
            this.map = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.map.containsValue(val);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet<K, V>(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public @JsNonNull Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = new UnmodifiableSet<K>(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public @JsNonNull Collection<V> values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection<V>(this.map.values());
            }
            return this.values;
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            public UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> s) {
                super(s);
            }

            @Override
            public boolean contains(Object o) {
                return this.coll.contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> o) {
                return this.coll.containsAll(o);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = this.coll.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry((Map.Entry)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] array = super.toArray();
                this.wrap(array, array.length);
                return array;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                Object[] result = super.toArray((E[])a);
                this.wrap(result, this.coll.size());
                return result;
            }

            private void wrap(Object[] array, int size) {
                for (int i = 0; i < size; ++i) {
                    array[i] = new UnmodifiableEntry((Map.Entry)array[i]);
                }
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> entry;

                public UnmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
                    this.entry = entry;
                }

                @Override
                public boolean equals(Object o) {
                    return this.entry.equals(o);
                }

                @Override
                public K getKey() {
                    return this.entry.getKey();
                }

                @Override
                public V getValue() {
                    return this.entry.getValue();
                }

                @Override
                public int hashCode() {
                    return this.entry.hashCode();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.entry.toString();
                }
            }
        }
    }

    static class UnmodifiableList<T>
    extends UnmodifiableCollection<T>
    implements List<T> {
        private final List<? extends T> list;

        public UnmodifiableList(List<? extends T> list) {
            super(list);
            this.list = list;
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator(int from) {
            return new UnmodifiableListIterator<T>(this.list.listIterator(from));
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @JsNonNull List<T> subList(int fromIndex, int toIndex) {
            return new UnmodifiableList<T>(this.list.subList(fromIndex, toIndex));
        }
    }

    static class UnmodifiableCollection<T>
    implements Collection<T> {
        protected final Collection<? extends T> coll;

        public UnmodifiableCollection(Collection<? extends T> coll) {
            this.coll = coll;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.coll.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.coll.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.coll.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new UnmodifiableCollectionIterator<T>(this.coll.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.coll.size();
        }

        @Override
        public Object[] toArray() {
            return this.coll.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this.coll.toArray(a);
        }

        public String toString() {
            return this.coll.toString();
        }
    }

    private static final class SingletonList<E>
    extends AbstractList<E>
    implements Serializable {
        private E element;

        public SingletonList(E element) {
            this.element = element;
        }

        @Override
        public boolean contains(Object item) {
            return Objects.equals(this.element, item);
        }

        @Override
        public E get(int index) {
            InternalPreconditions.checkElementIndex(index, 1);
            return this.element;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private final Map<E, Boolean> backingMap;
        private Set<E> keySet;

        SetFromMap(Map<E, Boolean> map) {
            this.backingMap = map;
        }

        @Override
        public boolean add(E e) {
            return this.backingMap.put(e, Boolean.TRUE) == null;
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingMap.containsKey(o);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.keySet().equals(o);
        }

        @Override
        public int hashCode() {
            return this.keySet().hashCode();
        }

        @Override
        public Iterator<E> iterator() {
            return this.keySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.backingMap.remove(o) != null;
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public String toString() {
            return this.keySet().toString();
        }

        private Set<E> keySet() {
            if (this.keySet == null) {
                this.keySet = this.backingMap.keySet();
            }
            return this.keySet;
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private EmptyMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Set entrySet() {
            return EMPTY_SET;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public @JsNonNull Set keySet() {
            return EMPTY_SET;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public @JsNonNull Collection values() {
            return EMPTY_LIST;
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private EmptySet() {
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Iterator iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static final class EmptyListIterator
    implements ListIterator {
        static final EmptyListIterator INSTANCE = new EmptyListIterator();

        private EmptyListIterator() {
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        public void set(Object o) {
            throw new IllegalStateException();
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private EmptyList() {
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Object get(int location) {
            InternalPreconditions.checkElementIndex(location, 0);
            return null;
        }

        @Override
        public Iterator iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static final class LifoQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private final Deque<E> deque;

        LifoQueue(Deque<E> deque) {
            this.deque = deque;
        }

        @Override
        public Iterator<E> iterator() {
            return this.deque.iterator();
        }

        @Override
        public boolean offer(E e) {
            return this.deque.offerFirst(e);
        }

        @Override
        public E peek() {
            return this.deque.peekFirst();
        }

        @Override
        public E poll() {
            return this.deque.pollFirst();
        }

        @Override
        public int size() {
            return this.deque.size();
        }
    }
}

