/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Comparators;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import javaemul.internal.InternalPreconditions;

@FunctionalInterface
public interface Comparator<T> {
    public int compare(T var1, T var2);

    public boolean equals(Object var1);

    default public Comparator<T> reversed() {
        return new Comparators.ReversedComparator(this);
    }

    default public Comparator<T> thenComparing(Comparator<? super T> other) {
        InternalPreconditions.checkNotNull(other);
        return (Comparator & Serializable)(a, b) -> {
            int c = this.compare(a, b);
            return c != 0 ? c : other.compare(a, b);
        };
    }

    default public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return this.thenComparing(Comparator.comparing(keyExtractor, keyComparator));
    }

    default public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor) {
        return this.thenComparing(Comparator.comparing(keyExtractor));
    }

    default public Comparator<T> thenComparingInt(ToIntFunction<? super T> keyExtractor) {
        return this.thenComparing(Comparator.comparingInt(keyExtractor));
    }

    default public Comparator<T> thenComparingLong(ToLongFunction<? super T> keyExtractor) {
        return this.thenComparing(Comparator.comparingLong(keyExtractor));
    }

    default public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        return this.thenComparing(Comparator.comparingDouble(keyExtractor));
    }

    public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        InternalPreconditions.checkNotNull(keyExtractor);
        InternalPreconditions.checkNotNull(keyComparator);
        return (Comparator & Serializable)(a, b) -> keyComparator.compare((Object)keyExtractor.apply(a), (Object)keyExtractor.apply(b));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
        return Comparator.comparing(keyExtractor, Comparator.naturalOrder());
    }

    public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        InternalPreconditions.checkNotNull(keyExtractor);
        return (Comparator & Serializable)(a, b) -> Double.compare(keyExtractor.applyAsDouble(a), keyExtractor.applyAsDouble(b));
    }

    public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> keyExtractor) {
        InternalPreconditions.checkNotNull(keyExtractor);
        return (Comparator & Serializable)(a, b) -> Integer.compare(keyExtractor.applyAsInt(a), keyExtractor.applyAsInt(b));
    }

    public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
        InternalPreconditions.checkNotNull(keyExtractor);
        return (Comparator & Serializable)(a, b) -> Long.compare(keyExtractor.applyAsLong(a), keyExtractor.applyAsLong(b));
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return Comparators.naturalOrder();
    }

    public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
        return new Comparators.NullComparator<T>(true, comparator);
    }

    public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
        return new Comparators.NullComparator<T>(false, comparator);
    }

    public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
        return Comparators.reverseNaturalOrder();
    }
}

