/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Comparator;
import javaemul.internal.InternalPreconditions;

class Comparators {
    private static final Comparator<Comparable<Object>> INTERNAL_NATURAL_ORDER = new NaturalOrderComparator();
    private static final Comparator<Comparable<Object>> NATURAL_ORDER = new NaturalOrderComparator();
    private static final Comparator<Comparable<Object>> REVERSE_NATURAL_ORDER = new ReverseNaturalOrderComparator();

    static <T> Comparator<T> naturalOrder() {
        return NATURAL_ORDER;
    }

    static <T> Comparator<T> reverseNaturalOrder() {
        return REVERSE_NATURAL_ORDER;
    }

    static <T> Comparator<T> nullToNaturalOrder(Comparator<T> cmp) {
        return cmp == null ? INTERNAL_NATURAL_ORDER : cmp;
    }

    static <T> Comparator<T> naturalOrderToNull(Comparator<T> cmp) {
        return cmp == INTERNAL_NATURAL_ORDER ? null : cmp;
    }

    static boolean isNaturalOrder(Comparator<?> cmp) {
        return cmp == INTERNAL_NATURAL_ORDER;
    }

    private Comparators() {
    }

    static final class NullComparator<T>
    implements Comparator<T>,
    Serializable {
        private final boolean nullFirst;
        private final Comparator<T> delegate;

        NullComparator(boolean nullFirst, Comparator<? super T> delegate) {
            this.nullFirst = nullFirst;
            this.delegate = delegate;
        }

        @Override
        public int compare(T a, T b) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.delegate == null ? 0 : this.delegate.compare(a, b);
        }

        @Override
        public Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.delegate == null ? null : this.delegate.reversed());
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullComparator<T>(this.nullFirst, this.delegate == null ? other : this.delegate.thenComparing(other));
        }
    }

    static final class ReversedComparator<T>
    implements Comparator<T>,
    Serializable {
        private final Comparator<T> comparator;

        ReversedComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T a, T b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public Comparator<T> reversed() {
            return this.comparator;
        }
    }

    private static final class ReverseNaturalOrderComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private ReverseNaturalOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> a, Comparable<Object> b) {
            return InternalPreconditions.checkNotNull(b).compareTo(InternalPreconditions.checkNotNull(a));
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return NATURAL_ORDER;
        }
    }

    private static final class NaturalOrderComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private NaturalOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> a, Comparable<Object> b) {
            return InternalPreconditions.checkNotNull(a).compareTo(InternalPreconditions.checkNotNull(b));
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return REVERSE_NATURAL_ORDER;
        }
    }
}

