/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import jsinterop.annotations.JsType;

public class Date
implements Cloneable,
Comparable<Date>,
Serializable {
    private final NativeDate jsdate;
    private static final long ONE_HOUR_IN_MILLISECONDS = 3600000L;

    public static long parse(String s) {
        double parsed = NativeDate.parse(s);
        if (Double.isNaN(parsed)) {
            throw new IllegalArgumentException();
        }
        return (long)parsed;
    }

    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        return (long)NativeDate.UTC(year + 1900, month, date, hrs, min, sec, 0);
    }

    protected static String padTwo(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public Date() {
        this.jsdate = new NativeDate();
    }

    public Date(int year, int month, int date) {
        this(year, month, date, 0, 0, 0);
    }

    public Date(int year, int month, int date, int hrs, int min) {
        this(year, month, date, hrs, min, 0);
    }

    public Date(int year, int month, int date, int hrs, int min, int sec) {
        this.jsdate = new NativeDate();
        this.jsdate.setFullYear(year + 1900, month, date);
        this.jsdate.setHours(hrs, min, sec, 0);
        this.fixDaylightSavings(hrs);
    }

    public Date(long date) {
        this.jsdate = new NativeDate(date);
    }

    public Date(String date) {
        this(Date.parse(date));
    }

    public boolean after(Date when) {
        return this.getTime() > when.getTime();
    }

    public boolean before(Date when) {
        return this.getTime() < when.getTime();
    }

    public Object clone() {
        return new Date(this.getTime());
    }

    @Override
    public int compareTo(Date other) {
        return Long.compare(this.getTime(), other.getTime());
    }

    public boolean equals(Object obj) {
        return obj instanceof Date && this.getTime() == ((Date)obj).getTime();
    }

    public int getDate() {
        return this.jsdate.getDate();
    }

    public int getDay() {
        return this.jsdate.getDay();
    }

    public int getHours() {
        return this.jsdate.getHours();
    }

    public int getMinutes() {
        return this.jsdate.getMinutes();
    }

    public int getMonth() {
        return this.jsdate.getMonth();
    }

    public int getSeconds() {
        return this.jsdate.getSeconds();
    }

    public long getTime() {
        return (long)this.jsdate.getTime();
    }

    public int getTimezoneOffset() {
        return this.jsdate.getTimezoneOffset();
    }

    public int getYear() {
        return this.jsdate.getFullYear() - 1900;
    }

    public int hashCode() {
        long time = this.getTime();
        return (int)(time ^ time >>> 32);
    }

    public void setDate(int date) {
        int hours = this.jsdate.getHours();
        this.jsdate.setDate(date);
        this.fixDaylightSavings(hours);
    }

    public void setHours(int hours) {
        this.jsdate.setHours(hours);
        this.fixDaylightSavings(hours);
    }

    public void setMinutes(int minutes) {
        int hours = this.getHours() + minutes / 60;
        this.jsdate.setMinutes(minutes);
        this.fixDaylightSavings(hours);
    }

    public void setMonth(int month) {
        int hours = this.jsdate.getHours();
        this.jsdate.setMonth(month);
        this.fixDaylightSavings(hours);
    }

    public void setSeconds(int seconds) {
        int hours = this.getHours() + seconds / 3600;
        this.jsdate.setSeconds(seconds);
        this.fixDaylightSavings(hours);
    }

    public void setTime(long time) {
        this.jsdate.setTime(time);
    }

    public void setYear(int year) {
        int hours = this.jsdate.getHours();
        this.jsdate.setFullYear(year + 1900);
        this.fixDaylightSavings(hours);
    }

    public String toGMTString() {
        return this.jsdate.getUTCDate() + " " + StringData.MONTHS[this.jsdate.getUTCMonth()] + " " + this.jsdate.getUTCFullYear() + " " + Date.padTwo(this.jsdate.getUTCHours()) + ":" + Date.padTwo(this.jsdate.getUTCMinutes()) + ":" + Date.padTwo(this.jsdate.getUTCSeconds()) + " GMT";
    }

    public String toLocaleString() {
        return this.jsdate.toLocaleString();
    }

    public String toString() {
        int offset = -this.jsdate.getTimezoneOffset();
        String hourOffset = (offset >= 0 ? "+" : "") + offset / 60;
        String minuteOffset = Date.padTwo(Math.abs(offset) % 60);
        return StringData.DAYS[this.jsdate.getDay()] + " " + StringData.MONTHS[this.jsdate.getMonth()] + " " + Date.padTwo(this.jsdate.getDate()) + " " + Date.padTwo(this.jsdate.getHours()) + ":" + Date.padTwo(this.jsdate.getMinutes()) + ":" + Date.padTwo(this.jsdate.getSeconds()) + " GMT" + hourOffset + minuteOffset + " " + this.jsdate.getFullYear();
    }

    private void fixDaylightSavings(int requestedHours) {
        if (this.jsdate.getHours() != (requestedHours %= 24)) {
            NativeDate copy = new NativeDate(this.jsdate.getTime());
            copy.setDate(copy.getDate() + 1);
            int timeDiff = this.jsdate.getTimezoneOffset() - copy.getTimezoneOffset();
            if (timeDiff > 0) {
                int timeDiffHours = timeDiff / 60;
                int timeDiffMinutes = timeDiff % 60;
                int day = this.jsdate.getDate();
                int badHours = this.jsdate.getHours();
                if (badHours + timeDiffHours >= 24) {
                    ++day;
                }
                NativeDate newTime = new NativeDate(this.jsdate.getFullYear(), this.jsdate.getMonth(), day, requestedHours + timeDiffHours, this.jsdate.getMinutes() + timeDiffMinutes, this.jsdate.getSeconds(), this.jsdate.getMilliseconds());
                this.jsdate.setTime(newTime.getTime());
            }
        }
        double originalTimeInMillis = this.jsdate.getTime();
        this.jsdate.setTime(originalTimeInMillis + 3600000.0);
        if (this.jsdate.getHours() != requestedHours) {
            this.jsdate.setTime(originalTimeInMillis);
        }
    }

    @JsType(isNative=true, name="Date", namespace="<global>")
    private static class NativeDate {
        public static native double UTC(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

        public static native double parse(String var0);

        public NativeDate() {
        }

        public NativeDate(double milliseconds) {
        }

        public NativeDate(int year, int month, int dayOfMonth, int hours, int minutes, int seconds, int millis) {
        }

        public native int getDate();

        public native int getDay();

        public native int getFullYear();

        public native int getHours();

        public native int getMilliseconds();

        public native int getMinutes();

        public native int getMonth();

        public native int getSeconds();

        public native double getTime();

        public native int getTimezoneOffset();

        public native int getUTCDate();

        public native int getUTCFullYear();

        public native int getUTCHours();

        public native int getUTCMinutes();

        public native int getUTCMonth();

        public native int getUTCSeconds();

        public native void setDate(int var1);

        public native void setFullYear(int var1);

        public native void setFullYear(int var1, int var2, int var3);

        public native void setHours(int var1);

        public native void setHours(int var1, int var2, int var3, int var4);

        public native void setMinutes(int var1);

        public native void setMonth(int var1);

        public native void setSeconds(int var1);

        public native void setTime(double var1);

        public native String toLocaleString();
    }

    private static class StringData {
        public static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        public static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        private StringData() {
        }
    }
}

