/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.DoubleConsumer;

public class DoubleSummaryStatistics
implements DoubleConsumer {
    private long count;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double sum;
    private double sumError;
    private double naiveSum;

    @Override
    public void accept(double value) {
        ++this.count;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.naiveSum += value;
        this.sum(value);
    }

    public void combine(DoubleSummaryStatistics other) {
        this.count += other.count;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
        this.naiveSum += other.naiveSum;
        this.sum(other.sum);
        this.sum(other.sumError);
    }

    public double getAverage() {
        return this.count > 0L ? this.getSum() / (double)this.count : 0.0;
    }

    public long getCount() {
        return this.count;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        double compensatedSum = this.sum + this.sumError;
        if (Double.isNaN(compensatedSum) && Double.isInfinite(this.naiveSum)) {
            return this.naiveSum;
        }
        return compensatedSum;
    }

    public String toString() {
        return "DoubleSummaryStatistics[count = " + this.count + ", avg = " + this.getAverage() + ", min = " + this.min + ", max = " + this.max + ", sum = " + this.getSum() + "]";
    }

    private void sum(double value) {
        double compensatedValue = value - this.sumError;
        double newSum = this.sum + compensatedValue;
        this.sumError = newSum - this.sum - compensatedValue;
        this.sum = newSum;
    }
}

