/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import javaemul.internal.InternalPreconditions;

public class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable {
    private TreeMap<E, Object> map = new TreeMap();

    EnumSet() {
    }

    @Override
    public boolean add(E e) {
        Object old = this.map.put(e, this);
        return old == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    public static <E extends Enum<E>> EnumSet<E> of(E first) {
        EnumSet<E> enumSet = new EnumSet<E>();
        enumSet.add(first);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E first, E ... rest) {
        EnumSet<E> enumSet = new EnumSet<E>();
        enumSet.add(first);
        for (E e : rest) {
            enumSet.add(e);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> c) {
        InternalPreconditions.checkArgument(c instanceof EnumSet || !c.isEmpty(), "Collection is empty");
        EnumSet<Enum> enumSet = new EnumSet<Enum>();
        for (Enum e : c) {
            enumSet.add(e);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> elementType) {
        return new EnumSet<E>();
    }

    public EnumSet<E> clone() {
        return EnumSet.copyOf(this);
    }
}

