/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractHashMap;
import java.util.AbstractMapEntry;
import java.util.InternalJsMap;
import java.util.Iterator;
import java.util.Map;
import javaemul.internal.JsUtils;

class InternalStringMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    private final InternalJsMap<V> backingMap = new InternalJsMap();
    private AbstractHashMap<K, V> host;
    private int size;
    private int valueMod;

    public InternalStringMap(AbstractHashMap<K, V> host) {
        this.host = host;
    }

    public boolean contains(String key) {
        return this.backingMap.has(key);
    }

    public V get(String key) {
        return this.backingMap.get(key);
    }

    public V put(String key, V value) {
        V oldValue = this.backingMap.get(key);
        this.backingMap.set(key, InternalStringMap.toNullIfUndefined(value));
        if (JsUtils.isUndefined(oldValue)) {
            ++this.size;
            this.host.structureChanged();
        } else {
            ++this.valueMod;
        }
        return oldValue;
    }

    public V remove(String key) {
        V value = this.backingMap.get(key);
        if (!JsUtils.isUndefined(value)) {
            this.backingMap.delete(key);
            --this.size;
            this.host.structureChanged();
        } else {
            ++this.valueMod;
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            InternalJsMap.Iterator<V> entries;
            InternalJsMap.IteratorEntry<V> current;
            InternalJsMap.IteratorEntry<V> last;
            {
                this.entries = InternalStringMap.this.backingMap.entries();
                this.current = this.entries.next();
            }

            @Override
            public boolean hasNext() {
                return !this.current.isDone();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.last = this.current;
                this.current = this.entries.next();
                return InternalStringMap.this.newMapEntry(this.last, InternalStringMap.this.valueMod);
            }

            @Override
            public void remove() {
                InternalStringMap.this.remove(this.last.getKey());
            }
        };
    }

    private Map.Entry<K, V> newMapEntry(final InternalJsMap.IteratorEntry<V> entry, final int lastValueMod) {
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                if (InternalStringMap.this.valueMod != lastValueMod) {
                    return InternalStringMap.this.get(entry.getKey());
                }
                return entry.getValue();
            }

            @Override
            public V setValue(V object) {
                return InternalStringMap.this.put(entry.getKey(), object);
            }
        };
    }

    private static <T> T toNullIfUndefined(T value) {
        return JsUtils.isUndefined(value) ? null : (T)value;
    }
}

