/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javaemul.internal.InternalPreconditions;

public class LinkedList<E>
extends AbstractSequentialList<E>
implements Cloneable,
List<E>,
Deque<E>,
Serializable {
    private E exposeElement;
    private final Node<E> header = new Node();
    private final Node<E> tail = new Node();
    private int size;

    public LinkedList() {
        this.reset();
    }

    public LinkedList(Collection<? extends E> c) {
        this.reset();
        this.addAll(c);
    }

    @Override
    public boolean add(E o) {
        this.addLast(o);
        return true;
    }

    @Override
    public void addFirst(E o) {
        this.addNode(o, this.header, this.header.next);
    }

    @Override
    public void addLast(E o) {
        this.addNode(o, this.tail.prev, this.tail);
    }

    @Override
    public void clear() {
        this.reset();
    }

    private void reset() {
        this.header.next = this.tail;
        this.tail.prev = this.header;
        this.tail.next = null;
        this.header.prev = null;
        this.size = 0;
    }

    public Object clone() {
        return new LinkedList<E>(this);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIteratorImpl();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getFirst() {
        InternalPreconditions.checkElement(this.size != 0);
        return this.header.next.value;
    }

    @Override
    public E getLast() {
        InternalPreconditions.checkElement(this.size != 0);
        return this.tail.prev.value;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Node<E> node;
        InternalPreconditions.checkPositionIndex(index, this.size);
        if (index >= this.size >> 1) {
            node = this.tail;
            for (int i = this.size; i > index; --i) {
                node = node.prev;
            }
        } else {
            node = this.header.next;
            for (int i = 0; i < index; ++i) {
                node = node.next;
            }
        }
        return new ListIteratorImpl(index, node);
    }

    @Override
    public boolean offer(E o) {
        return this.offerLast(o);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        return this.size == 0 ? null : (E)this.getFirst();
    }

    @Override
    public E peekLast() {
        return this.size == 0 ? null : (E)this.getLast();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        return this.size == 0 ? null : (E)this.removeFirst();
    }

    @Override
    public E pollLast() {
        return this.size == 0 ? null : (E)this.removeLast();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E removeFirst() {
        InternalPreconditions.checkElement(this.size != 0);
        return this.removeNode(this.header.next);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public E removeLast() {
        InternalPreconditions.checkElement(this.size != 0);
        return this.removeNode(this.tail.prev);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Node e = this.tail.prev;
        while (e != this.header) {
            if (Objects.equals(e.value, o)) {
                this.removeNode(e);
                return true;
            }
            e = e.prev;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void addNode(E o, Node<E> prev, Node<E> next) {
        Node node = new Node();
        node.value = o;
        node.prev = prev;
        node.next = next;
        prev.next = node;
        next.prev = prev.next;
        ++this.size;
    }

    private E removeNode(Node<E> node) {
        Object oldValue = node.value;
        node.next.prev = node.prev;
        node.prev.next = node.next;
        node.prev = null;
        node.next = null;
        node.value = null;
        --this.size;
        return oldValue;
    }

    private static class Node<E> {
        public Node<E> next;
        public Node<E> prev;
        public E value;

        private Node() {
        }
    }

    private final class ListIteratorImpl
    implements ListIterator<E> {
        protected int currentIndex;
        protected Node<E> currentNode;
        protected Node<E> lastNode = null;

        public ListIteratorImpl(int index, Node<E> startNode) {
            this.currentNode = startNode;
            this.currentIndex = index;
        }

        @Override
        public void add(E o) {
            LinkedList.this.addNode(o, this.currentNode.prev, this.currentNode);
            ++this.currentIndex;
            this.lastNode = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != LinkedList.this.tail;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentNode.prev != LinkedList.this.header;
        }

        @Override
        public E next() {
            InternalPreconditions.checkElement(this.hasNext());
            this.lastNode = this.currentNode;
            this.currentNode = this.currentNode.next;
            ++this.currentIndex;
            return this.lastNode.value;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public E previous() {
            InternalPreconditions.checkElement(this.hasPrevious());
            this.currentNode = this.currentNode.prev;
            this.lastNode = this.currentNode;
            --this.currentIndex;
            return this.lastNode.value;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.lastNode != null);
            Node nextNode = this.lastNode.next;
            LinkedList.this.removeNode(this.lastNode);
            if (this.currentNode == this.lastNode) {
                this.currentNode = nextNode;
            } else {
                --this.currentIndex;
            }
            this.lastNode = null;
        }

        @Override
        public void set(E o) {
            InternalPreconditions.checkState(this.lastNode != null);
            this.lastNode.value = o;
        }
    }

    private final class DescendingIteratorImpl
    implements Iterator<E> {
        private final ListIterator<E> itr;

        private DescendingIteratorImpl() {
            this.itr = new ListIteratorImpl(LinkedList.this.size, LinkedList.this.tail);
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

