/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public class LongSummaryStatistics
implements LongConsumer,
IntConsumer {
    private long count;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long sum;

    @Override
    public void accept(int value) {
        this.accept((long)value);
    }

    @Override
    public void accept(long value) {
        ++this.count;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.sum += value;
    }

    public void combine(LongSummaryStatistics other) {
        this.count += other.count;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
        this.sum += other.sum;
    }

    public double getAverage() {
        return this.count > 0L ? (double)this.sum / (double)this.count : 0.0;
    }

    public long getCount() {
        return this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public String toString() {
        return "LongSummaryStatistics[count = " + this.count + ", avg = " + this.getAverage() + ", min = " + this.min + ", max = " + this.max + ", sum = " + this.sum + "]";
    }
}

