/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsNonNull;
import jsinterop.annotations.JsType;

@JsType
public interface Map<K, V> {
    @JsIgnore
    public static <K, V> Map<K, V> of() {
        return Collections.internalMapOf(new Object[0]);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K key, V value) {
        return Collections.internalMapOf(key, value);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return Collections.internalMapOf(k1, v1, k2, v2);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
    }

    @JsIgnore
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return Collections.internalMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9, k10, v10);
    }

    @JsIgnore
    public static <K, V> Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(InternalPreconditions.checkNotNull(key), InternalPreconditions.checkNotNull(value));
    }

    @JsIgnore
    public static <K, V> Map<K, V> ofEntries(Entry<? extends K, ? extends V> ... entries) {
        return Collections.internalMapFromEntries(Arrays.asList(entries));
    }

    @JsIgnore
    public static <A, B> Map<A, B> copyOf(Map<? extends A, ? extends B> map) {
        return Collections.internalMapFromEntries(map.entrySet());
    }

    public void clear();

    @JsIgnore
    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        InternalPreconditions.checkNotNull(remappingFunction);
        V value = remappingFunction.apply(key, this.get(key));
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
        return value;
    }

    @JsIgnore
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> remappingFunction) {
        InternalPreconditions.checkNotNull(remappingFunction);
        V value = this.get(key);
        if (value == null && (value = remappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @JsIgnore
    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        InternalPreconditions.checkNotNull(remappingFunction);
        V value = this.get(key);
        if (value != null) {
            if ((value = remappingFunction.apply(key, value)) != null) {
                this.put(key, value);
            } else {
                this.remove(key);
            }
        }
        return value;
    }

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public Set<Entry<K, V>> entrySet();

    @JsIgnore
    default public void forEach(BiConsumer<? super K, ? super V> consumer) {
        InternalPreconditions.checkNotNull(consumer);
        for (Entry<K, V> entry : this.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public V get(Object var1);

    default public V getOrDefault(Object key, V defaultValue) {
        V currentValue = this.get(key);
        return currentValue == null && !this.containsKey(key) ? defaultValue : currentValue;
    }

    public boolean isEmpty();

    public @JsNonNull Set<K> keySet();

    @JsIgnore
    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        InternalPreconditions.checkNotNull(remappingFunction);
        InternalPreconditions.checkNotNull(value);
        V currentValue = this.get(key);
        V v = newValue = currentValue == null ? value : remappingFunction.apply(currentValue, value);
        if (newValue == null) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    public V put(K var1, V var2);

    default public V putIfAbsent(K key, V value) {
        V currentValue = this.get(key);
        return currentValue != null ? currentValue : this.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> var1);

    public V remove(Object var1);

    @JsIgnore
    default public boolean remove(Object key, Object value) {
        V currentValue = this.get(key);
        if (!Objects.equals(currentValue, value) || currentValue == null && !this.containsKey(key)) {
            return false;
        }
        this.remove(key);
        return true;
    }

    default public V replace(K key, V value) {
        return this.containsKey(key) ? (V)this.put(key, value) : null;
    }

    @JsIgnore
    default public boolean replace(K key, V oldValue, V newValue) {
        V currentValue = this.get(key);
        if (!Objects.equals(currentValue, oldValue) || currentValue == null && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @JsIgnore
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        InternalPreconditions.checkNotNull(function);
        for (Entry<K, V> entry : this.entrySet()) {
            entry.setValue(function.apply(entry.getKey(), entry.getValue()));
        }
    }

    public int size();

    public @JsNonNull Collection<V> values();

    public boolean equals(Object var1);

    public static interface Entry<K, V> {
        public boolean equals(Object var1);

        @JsMethod
        public K getKey();

        @JsMethod
        public V getValue();

        public int hashCode();

        @JsMethod
        public V setValue(V var1);

        public static <K extends Comparable<? super K>, V> Comparator<Entry<K, V>> comparingByKey() {
            return Entry.comparingByKey(Comparator.naturalOrder());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByKey(Comparator<? super K> cmp) {
            InternalPreconditions.checkNotNull(cmp);
            return (Comparator & Serializable)(a, b) -> cmp.compare((Object)a.getKey(), (Object)b.getKey());
        }

        public static <K, V extends Comparable<? super V>> Comparator<Entry<K, V>> comparingByValue() {
            return Entry.comparingByValue(Comparator.naturalOrder());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByValue(Comparator<? super V> cmp) {
            InternalPreconditions.checkNotNull(cmp);
            return (Comparator & Serializable)(a, b) -> cmp.compare((Object)a.getValue(), (Object)b.getValue());
        }
    }
}

